/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.encoder;

import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.handover.records.ErrorRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class ErrorRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        ErrorRecord errorRecord = (ErrorRecord)wellKnownRecord;
        if (!errorRecord.hasErrorReason()) {
            throw new NdefEncoderException("Expected error reason", wellKnownRecord);
        }
        if (!errorRecord.hasErrorData()) {
            throw new NdefEncoderException("Expected error data", wellKnownRecord);
        }
        ErrorRecord.ErrorReason errorReason = errorRecord.getErrorReason();
        switch (errorReason) {
            case TemporaryMemoryConstraints: {
                return new byte[]{errorReason.getValue(), (byte)(errorRecord.getErrorData().shortValue() & 0xFF)};
            }
            case PermanenteMemoryConstraints: {
                long unsignedInt = errorRecord.getErrorData().longValue();
                return new byte[]{errorReason.getValue(), (byte)(unsignedInt >> 24 & 0xFFL), (byte)(unsignedInt >> 16 & 0xFFL), (byte)(unsignedInt >> 8 & 0xFFL), (byte)(unsignedInt & 0xFFL)};
            }
            case CarrierSpecificConstraints: {
                return new byte[]{errorReason.getValue(), (byte)(errorRecord.getErrorData().shortValue() & 0xFF)};
            }
        }
        throw new NdefEncoderException("Unknown error reason " + (Object)((Object)errorReason), wellKnownRecord);
    }
}

