/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.encoder;

import java.io.ByteArrayOutputStream;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.ext.ExternalTypeRecord;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.handover.records.HandoverCarrierRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverCarrierRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        byte[] encoded;
        HandoverCarrierRecord handoverCarrierRecord = (HandoverCarrierRecord)wellKnownRecord;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HandoverCarrierRecord.CarrierTypeFormat carrierTypeFormat = handoverCarrierRecord.getCarrierTypeFormat();
        if (carrierTypeFormat == null) {
            throw new NdefEncoderException("Expected carrier type format", handoverCarrierRecord);
        }
        bout.write(carrierTypeFormat.getValue() & 7);
        Object carrierType = handoverCarrierRecord.getCarrierType();
        switch (carrierTypeFormat) {
            case WellKnown: {
                if (carrierType instanceof WellKnownRecord) {
                    WellKnownRecord abstractWellKnownRecord = (WellKnownRecord)((Object)carrierType);
                    encoded = messageEncoder.encodeSingle(abstractWellKnownRecord);
                    break;
                }
                throw new NdefEncoderException("Expected well-known record to be of supertype " + WellKnownRecord.class.getName(), handoverCarrierRecord);
            }
            case Media: {
                String string = (String)carrierType;
                encoded = string.getBytes(NdefConstants.DEFAULT_CHARSET);
                break;
            }
            case AbsoluteURI: {
                String string = (String)carrierType;
                encoded = string.getBytes(NdefConstants.DEFAULT_CHARSET);
                break;
            }
            case External: {
                if (carrierType instanceof ExternalTypeRecord) {
                    ExternalTypeRecord externalTypeRecord = (ExternalTypeRecord)((Object)carrierType);
                    encoded = messageEncoder.encodeSingle(externalTypeRecord);
                    break;
                }
                throw new NdefEncoderException("Expected external type record to be of supertype " + ExternalTypeRecord.class.getName(), handoverCarrierRecord);
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (encoded.length > 255) {
            throw new NdefEncoderException("Carrier type 255 byte limit exceeded.", handoverCarrierRecord);
        }
        bout.write(encoded.length);
        bout.write(encoded, 0, encoded.length);
        if (handoverCarrierRecord.hasCarrierData()) {
            bout.write(handoverCarrierRecord.getCarrierData(), 0, handoverCarrierRecord.getCarrierDataSize());
        }
        return bout.toByteArray();
    }
}

