/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.encoder;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.handover.records.HandoverRequestRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverRequestRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        HandoverRequestRecord handoverRequestRecord = (HandoverRequestRecord)wellKnownRecord;
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        payload.write(handoverRequestRecord.getMajorVersion() << 4 | handoverRequestRecord.getMinorVersion());
        if (!handoverRequestRecord.hasCollisionResolution()) {
            throw new NdefEncoderException("Expected collision resolution", handoverRequestRecord);
        }
        if (!handoverRequestRecord.hasAlternativeCarriers()) {
            throw new NdefEncoderException("Expected at least one alternative carrier", handoverRequestRecord);
        }
        ArrayList<WellKnownRecord> records = new ArrayList<WellKnownRecord>();
        records.add(handoverRequestRecord.getCollisionResolution());
        records.addAll(handoverRequestRecord.getAlternativeCarriers());
        messageEncoder.encode(records, payload);
        return payload.toByteArray();
    }
}

