/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.records;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class SignatureRecord
extends WellKnownRecord {
    private byte version = 1;
    private SignatureType signatureType;
    private byte[] signature;
    private String signatureUri;
    private CertificateFormat certificateFormat;
    private String certificateUri;
    private List<byte[]> certificates = new ArrayList<byte[]>();

    public SignatureRecord() {
    }

    public SignatureRecord(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature) {
        this(signatureType);
        this.signature = signature;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri) {
        this(signatureType);
        this.signatureUri = signatureUri;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature, CertificateFormat certificateFormat) {
        this(signatureType, signature);
        this.certificateFormat = certificateFormat;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri, CertificateFormat certificateFormat) {
        this(signatureType, signatureUri);
        this.certificateFormat = certificateFormat;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature, CertificateFormat certificateFormat, String certificateUri) {
        this(signatureType, signature, certificateFormat);
        this.signature = signature;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri, CertificateFormat certificateFormat, String certificateUri) {
        this(signatureType, signatureUri, certificateFormat);
        this.signatureUri = signatureUri;
    }

    public boolean isStartMarker() {
        return this.signatureType == SignatureType.NOT_PRESENT && this.signature == null && this.signatureUri == null;
    }

    public boolean hasCertificateUri() {
        return this.certificateUri != null;
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    public boolean hasSignatureUri() {
        return this.signatureUri != null;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public CertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(CertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public List<byte[]> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<byte[]> certificates) {
        this.certificates = certificates;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getSignatureUri() {
        return this.signatureUri;
    }

    public void setSignatureUri(String signatureUri) {
        this.signatureUri = signatureUri;
    }

    public String getCertificateUri() {
        return this.certificateUri;
    }

    public void setCertificateUri(String certificateUri) {
        this.certificateUri = certificateUri;
    }

    public boolean hasSignatureType() {
        return this.signatureType != null;
    }

    public boolean hasCertificateFormat() {
        return this.certificateFormat != null;
    }

    public void add(byte[] certificate) {
        this.certificates.add(certificate);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificateFormat == null ? 0 : this.certificateFormat.hashCode());
        result = 31 * result + (this.certificateUri == null ? 0 : this.certificateUri.hashCode());
        result = 31 * result + (this.certificates == null ? 0 : this.certificatesHash());
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + (this.signatureType == null ? 0 : this.signatureType.hashCode());
        result = 31 * result + (this.signatureUri == null ? 0 : this.signatureUri.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SignatureRecord other = (SignatureRecord)((Object)obj);
        if (this.certificateFormat != other.certificateFormat) {
            return false;
        }
        if (this.certificateUri == null ? other.certificateUri != null : !this.certificateUri.equals(other.certificateUri)) {
            return false;
        }
        if (!Arrays.equals(this.signature, other.signature)) {
            return false;
        }
        if (this.signatureType != other.signatureType) {
            return false;
        }
        if (this.signatureUri == null ? other.signatureUri != null : !this.signatureUri.equals(other.signatureUri)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return this.certificatesEquals(other);
    }

    private int certificatesHash() {
        int hash;
        if (this.certificates != null) {
            hash = this.certificates.size();
            for (byte[] certificate : this.certificates) {
                hash += Arrays.hashCode(certificate);
            }
        } else {
            hash = 0;
        }
        return hash;
    }

    private boolean certificatesEquals(SignatureRecord other) {
        if (this.certificates == null) {
            if (other.certificates != null) {
                return false;
            }
        } else {
            if (other.certificates == null) {
                return false;
            }
            if (other.certificates.size() != this.certificates.size()) {
                return false;
            }
            for (int i = 0; i < this.certificates.size(); ++i) {
                byte[] thisCertificate;
                byte[] otherCertificate = other.certificates.get(i);
                if (Arrays.equals(otherCertificate, thisCertificate = this.certificates.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static enum CertificateFormat {
        X_509(0),
        X9_68(1);

        private byte value;

        private CertificateFormat(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static CertificateFormat toCertificateFormat(int i) {
            for (CertificateFormat type : CertificateFormat.values()) {
                if (type.value != i) continue;
                return type;
            }
            throw new IllegalArgumentException("Unexpected certificate format " + i);
        }
    }

    public static enum SignatureType {
        NOT_PRESENT(0),
        RSASSA_PSS_SHA_1(1),
        RSASSA_PKCS1_v1_5_WITH_SHA_1(2),
        DSA(3),
        ECDSA(4);

        private byte value;

        private SignatureType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static SignatureType toSignatureType(int i) {
            for (SignatureType type : SignatureType.values()) {
                if (type.value != i) continue;
                return type;
            }
            throw new IllegalArgumentException("Unexpected signature type " + i);
        }
    }
}

