/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.schema;

import java.net.URL;

public final class SchemaResolver {
    private static final Entry[] entries = new Entry[2];

    private static Entry getEntry(String publicId, String systemId) {
        if (publicId == null) {
            return null;
        }
        for (int i = 0; i < entries.length; ++i) {
            Entry entry = entries[i];
            if (!publicId.equals(entry.publicId) || systemId != null && !systemId.equals(entry.systemId)) continue;
            return entry;
        }
        return null;
    }

    public static URL resolve(String publicId, String systemId) {
        if (publicId == null) {
            return null;
        }
        Entry entry = SchemaResolver.getEntry(publicId, systemId);
        if (entry == null) {
            return null;
        }
        if (entry.url != null) {
            return entry.url;
        }
        URL url = SchemaResolver.class.getClassLoader().getResource(entry.resourcePath);
        if (url == null) {
            throw new IllegalStateException();
        }
        return entry.url = url;
    }

    private SchemaResolver() {
    }

    static {
        SchemaResolver.entries[0] = new Entry("http://www.w3.org/2001/XMLSchema", null, "xmlschema/XMLSchema.xsd");
        SchemaResolver.entries[1] = new Entry("http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/xml.xsd", "xmlschema/xml.xsd");
    }

    private static class Entry {
        private final String publicId;
        private final String systemId;
        private final String resourcePath;
        private URL url;

        private Entry(String publicId, String systemId, String resourcePath) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.resourcePath = resourcePath;
        }
    }
}

