/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ProfileActivation;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

@XmlRootElement(name="project")
public class RawPom {
    @Nullable
    private final String pomVersion;
    @Nullable
    private final Parent parent;
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String currentVersion;
    @Nullable
    private String snapshotVersion;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String packaging;
    @Nullable
    private final Dependencies dependencies;
    @Nullable
    private final DependencyManagement dependencyManagement;
    @Nullable
    private final Map<String, String> properties;
    @Nullable
    private final Build build;
    @Nullable
    private final RawRepositories repositories;
    @Nullable
    private final Licenses licenses;
    @Nullable
    private final Profiles profiles;

    public static RawPom parse(InputStream inputStream, @Nullable String snapshotVersion) {
        try {
            RawPom pom = (RawPom)MavenXmlMapper.readMapper().readValue(inputStream, RawPom.class);
            if (snapshotVersion != null) {
                pom.setSnapshotVersion(snapshotVersion);
            }
            return pom;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse pom", e);
        }
    }

    @Nullable
    public String getGroupId() {
        return this.groupId == null && this.parent != null ? this.parent.getGroupId() : this.groupId;
    }

    @Nullable
    public String getVersion() {
        if (this.version == null) {
            if (this.currentVersion == null) {
                if (this.parent == null) {
                    return null;
                }
                return this.parent.getVersion();
            }
            return this.currentVersion;
        }
        return this.version;
    }

    public Pom toPom(@Nullable Path inputPath, @Nullable MavenRepository repo) {
        org.openrewrite.maven.tree.Parent parent = this.getParent() == null ? null : new org.openrewrite.maven.tree.Parent(new GroupArtifactVersion(this.getParent().getGroupId(), this.getParent().getArtifactId(), this.getParent().getVersion()), this.getParent().getRelativePath());
        Pom.PomBuilder builder = Pom.builder().sourcePath(inputPath).repository(repo).parent(parent).gav(new ResolvedGroupArtifactVersion(repo == null ? null : repo.getUri(), Objects.requireNonNull(this.getGroupId()), this.artifactId, Objects.requireNonNull(this.getVersion()), null)).name(this.name).obsoletePomVersion(this.pomVersion).packaging(this.packaging).properties(this.getProperties() == null ? Collections.emptyMap() : this.getProperties()).licenses(this.mapLicenses(this.getLicenses())).profiles(this.mapProfiles(this.getProfiles()));
        if (StringUtils.isBlank((String)this.pomVersion)) {
            builder.dependencies(this.mapRequestedDependencies(this.getDependencies())).dependencyManagement(this.mapDependencyManagement(this.getDependencyManagement())).repositories(this.mapRepositories(this.getRepositories())).plugins(this.mapPlugins(this.build != null ? this.build.getPlugins() : null)).pluginManagement(this.mapPlugins(this.build != null && this.build.getPluginManagement() != null ? this.build.getPluginManagement().getPlugins() : null));
        }
        return builder.build();
    }

    private List<org.openrewrite.maven.tree.License> mapLicenses(@Nullable Licenses rawLicenses) {
        List<License> unmappedLicenses;
        List<org.openrewrite.maven.tree.License> licenses = Collections.emptyList();
        if (rawLicenses != null && (unmappedLicenses = rawLicenses.getLicenses()) != null) {
            licenses = new ArrayList<org.openrewrite.maven.tree.License>(unmappedLicenses.size());
            for (License l : unmappedLicenses) {
                licenses.add(org.openrewrite.maven.tree.License.fromName(l.getName()));
            }
        }
        return licenses;
    }

    private List<org.openrewrite.maven.tree.Profile> mapProfiles(@Nullable Profiles rawProfiles) {
        List<Profile> unmappedProfiles;
        List<org.openrewrite.maven.tree.Profile> profiles = Collections.emptyList();
        if (rawProfiles != null && (unmappedProfiles = rawProfiles.getProfiles()) != null) {
            profiles = new ArrayList<org.openrewrite.maven.tree.Profile>(unmappedProfiles.size());
            for (int i = unmappedProfiles.size() - 1; i >= 0; --i) {
                Profile p = unmappedProfiles.get(i);
                profiles.add(new org.openrewrite.maven.tree.Profile(p.getId(), p.getActivation(), p.getProperties() == null ? Collections.emptyMap() : p.getProperties(), this.mapRequestedDependencies(p.getDependencies()), this.mapDependencyManagement(p.getDependencyManagement()), this.mapRepositories(p.getRepositories()), this.mapPlugins(this.build != null ? this.build.getPlugins() : null), this.mapPlugins(this.build != null && this.build.getPluginManagement() != null ? this.build.getPluginManagement().getPlugins() : null)));
            }
        }
        return profiles;
    }

    @NonNull
    private List<MavenRepository> mapRepositories(@Nullable RawRepositories rawRepositories) {
        List<RawRepositories.Repository> unmappedRepos;
        List<MavenRepository> pomRepositories = Collections.emptyList();
        if (rawRepositories != null && (unmappedRepos = rawRepositories.getRepositories()) != null) {
            pomRepositories = new ArrayList<MavenRepository>(unmappedRepos.size());
            for (RawRepositories.Repository r : unmappedRepos) {
                pomRepositories.add(new MavenRepository(r.getId(), r.getUrl(), r.getReleases() == null ? null : r.getReleases().getEnabled(), r.getSnapshots() == null ? null : r.getSnapshots().getEnabled(), false, null, null, null, null));
            }
        }
        return pomRepositories;
    }

    private List<ManagedDependency> mapDependencyManagement(@Nullable DependencyManagement rawDependencyManagement) {
        List<Dependency> unmappedDependencies;
        List<ManagedDependency> dependencyManagementDependencies = Collections.emptyList();
        if (rawDependencyManagement != null && rawDependencyManagement.getDependencies() != null && (unmappedDependencies = rawDependencyManagement.getDependencies().getDependencies()) != null) {
            dependencyManagementDependencies = new ArrayList<ManagedDependency>(unmappedDependencies.size());
            for (Dependency d : unmappedDependencies) {
                GroupArtifactVersion dGav = new GroupArtifactVersion(d.getGroupId(), d.getArtifactId(), d.getVersion());
                if ("import".equals(d.getScope())) {
                    dependencyManagementDependencies.add(new ManagedDependency.Imported(dGav));
                    continue;
                }
                dependencyManagementDependencies.add(new ManagedDependency.Defined(dGav, d.getScope(), d.getType(), d.getClassifier(), d.getExclusions()));
            }
        }
        return dependencyManagementDependencies;
    }

    private List<org.openrewrite.maven.tree.Dependency> mapRequestedDependencies(@Nullable Dependencies rawDependencies) {
        List<Dependency> unmappedDependencies;
        List<org.openrewrite.maven.tree.Dependency> dependencies = Collections.emptyList();
        if (rawDependencies != null && rawDependencies.getDependencies() != null && (unmappedDependencies = rawDependencies.getDependencies()) != null) {
            dependencies = new ArrayList<org.openrewrite.maven.tree.Dependency>(unmappedDependencies.size());
            for (Dependency d : unmappedDependencies) {
                GroupArtifactVersion dGav = new GroupArtifactVersion(d.getGroupId(), d.getArtifactId(), d.getVersion());
                dependencies.add(new org.openrewrite.maven.tree.Dependency(dGav, d.getClassifier(), d.getType(), d.getScope(), d.getExclusions(), d.getOptional()));
            }
        }
        return dependencies;
    }

    private List<org.openrewrite.maven.tree.Dependency> mapRequestedDependencies(@Nullable List<Dependency> rawDependencies) {
        List<org.openrewrite.maven.tree.Dependency> dependencies = Collections.emptyList();
        if (rawDependencies != null) {
            dependencies = new ArrayList<org.openrewrite.maven.tree.Dependency>(rawDependencies.size());
            for (Dependency d : rawDependencies) {
                GroupArtifactVersion dGav = new GroupArtifactVersion(d.getGroupId(), d.getArtifactId(), d.getVersion());
                dependencies.add(new org.openrewrite.maven.tree.Dependency(dGav, d.getClassifier(), d.getType(), d.getScope(), d.getExclusions(), d.getOptional()));
            }
        }
        return dependencies;
    }

    private List<org.openrewrite.maven.tree.Plugin> mapPlugins(@Nullable List<Plugin> rawPlugins) {
        List<org.openrewrite.maven.tree.Plugin> plugins = Collections.emptyList();
        if (rawPlugins != null) {
            plugins = new ArrayList<org.openrewrite.maven.tree.Plugin>(rawPlugins.size());
            for (Plugin rawPlugin : rawPlugins) {
                plugins.add(new org.openrewrite.maven.tree.Plugin(rawPlugin.getGroupId(), rawPlugin.getArtifactId(), rawPlugin.getVersion(), rawPlugin.getExtensions(), rawPlugin.getInherited(), rawPlugin.getConfiguration(), this.mapRequestedDependencies(rawPlugin.getDependencies()), this.mapPluginExecutions(rawPlugin.getExecutions())));
            }
        }
        return plugins;
    }

    private Map<String, Object> mapPluginConfiguration(@Nullable JsonNode configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)MavenXmlMapper.readMapper().convertValue((Object)configuration, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private List<Plugin.Execution> mapPluginExecutions(@Nullable List<Execution> rawExecutions) {
        List<Plugin.Execution> executions = Collections.emptyList();
        if (rawExecutions != null) {
            executions = new ArrayList<Plugin.Execution>(rawExecutions.size());
            for (Execution rawExecution : rawExecutions) {
                executions.add(new Plugin.Execution(rawExecution.getId(), rawExecution.getGoals(), rawExecution.getPhase(), rawExecution.getInherited(), rawExecution.getConfiguration()));
            }
        }
        return executions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RawPom(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", snapshotVersion=" + this.getSnapshotVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawPom)) {
            return false;
        }
        RawPom other = (RawPom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$snapshotVersion = this.getSnapshotVersion();
        String other$snapshotVersion = other.getSnapshotVersion();
        return !(this$snapshotVersion == null ? other$snapshotVersion != null : !this$snapshotVersion.equals(other$snapshotVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RawPom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $snapshotVersion = this.getSnapshotVersion();
        result = result * 59 + ($snapshotVersion == null ? 43 : $snapshotVersion.hashCode());
        return result;
    }

    @Generated
    public RawPom(@Nullable String pomVersion, @Nullable Parent parent, @Nullable String groupId, String artifactId, @Nullable String version, @Nullable String currentVersion, @Nullable String name, @Nullable String description, @Nullable String packaging, @Nullable Dependencies dependencies, @Nullable DependencyManagement dependencyManagement, @Nullable Map<String, String> properties, @Nullable Build build, @Nullable RawRepositories repositories, @Nullable Licenses licenses, @Nullable Profiles profiles) {
        this.pomVersion = pomVersion;
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.currentVersion = currentVersion;
        this.name = name;
        this.description = description;
        this.packaging = packaging;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.properties = properties;
        this.build = build;
        this.repositories = repositories;
        this.licenses = licenses;
        this.profiles = profiles;
    }

    @Nullable
    @Generated
    public String getPomVersion() {
        return this.pomVersion;
    }

    @Nullable
    @Generated
    public Parent getParent() {
        return this.parent;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    @Generated
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Nullable
    @Generated
    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @Generated
    public String getPackaging() {
        return this.packaging;
    }

    @Nullable
    @Generated
    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @Nullable
    @Generated
    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    @Nullable
    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    @Generated
    public Build getBuild() {
        return this.build;
    }

    @Nullable
    @Generated
    public RawRepositories getRepositories() {
        return this.repositories;
    }

    @Nullable
    @Generated
    public Licenses getLicenses() {
        return this.licenses;
    }

    @Nullable
    @Generated
    public Profiles getProfiles() {
        return this.profiles;
    }

    @Generated
    void setSnapshotVersion(@Nullable String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public static class Parent {
        private final String groupId;
        private final String artifactId;
        private final String version;
        @Nullable
        private final String relativePath;

        @Generated
        public Parent(String groupId, String artifactId, String version, @Nullable String relativePath) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.relativePath = relativePath;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Nullable
        @Generated
        public String getRelativePath() {
            return this.relativePath;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Parent(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", relativePath=" + this.getRelativePath() + ")";
        }
    }

    public static class Licenses {
        private final List<License> licenses;

        public Licenses() {
            this.licenses = Collections.emptyList();
        }

        public Licenses(@JacksonXmlProperty(localName="license") List<License> licenses) {
            this.licenses = licenses;
        }

        @Generated
        public List<License> getLicenses() {
            return this.licenses;
        }
    }

    public static class Profiles {
        private final List<Profile> profiles;

        public Profiles() {
            this.profiles = Collections.emptyList();
        }

        public Profiles(@JacksonXmlProperty(localName="profile") List<Profile> profiles) {
            this.profiles = profiles;
        }

        @Generated
        public List<Profile> getProfiles() {
            return this.profiles;
        }
    }

    public static class Dependencies {
        private final List<Dependency> dependencies;

        public Dependencies() {
            this.dependencies = Collections.emptyList();
        }

        public Dependencies(@JacksonXmlProperty(localName="dependency") List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        @Generated
        public List<Dependency> getDependencies() {
            return this.dependencies;
        }
    }

    public static class DependencyManagement {
        @Nullable
        private final Dependencies dependencies;

        public DependencyManagement() {
            this.dependencies = null;
        }

        public DependencyManagement(@JsonProperty(value="dependencies") @Nullable Dependencies dependencies) {
            this.dependencies = dependencies;
        }

        @Nullable
        @Generated
        public Dependencies getDependencies() {
            return this.dependencies;
        }
    }

    public static class Build {
        @Nullable
        @JacksonXmlElementWrapper(localName="plugins")
        @JacksonXmlProperty(localName="plugin")
        private List<Plugin> plugins;
        @Nullable
        @JacksonXmlProperty(localName="pluginManagement")
        private PluginManagement pluginManagement;

        public Build() {
            this.plugins = null;
            this.pluginManagement = null;
        }

        @Nullable
        @Generated
        public List<Plugin> getPlugins() {
            return this.plugins;
        }

        @Nullable
        @Generated
        public PluginManagement getPluginManagement() {
            return this.pluginManagement;
        }

        @JacksonXmlElementWrapper(localName="plugins")
        @JacksonXmlProperty(localName="plugin")
        @Generated
        public void setPlugins(@Nullable List<Plugin> plugins) {
            this.plugins = plugins;
        }

        @JacksonXmlProperty(localName="pluginManagement")
        @Generated
        public void setPluginManagement(@Nullable PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Build)) {
                return false;
            }
            Build other = (Build)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Plugin> this$plugins = this.getPlugins();
            List<Plugin> other$plugins = other.getPlugins();
            if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
                return false;
            }
            PluginManagement this$pluginManagement = this.getPluginManagement();
            PluginManagement other$pluginManagement = other.getPluginManagement();
            return !(this$pluginManagement == null ? other$pluginManagement != null : !((Object)this$pluginManagement).equals(other$pluginManagement));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Build;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Plugin> $plugins = this.getPlugins();
            result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
            PluginManagement $pluginManagement = this.getPluginManagement();
            result = result * 59 + ($pluginManagement == null ? 43 : ((Object)$pluginManagement).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Build(plugins=" + this.getPlugins() + ", pluginManagement=" + this.getPluginManagement() + ")";
        }

        @Generated
        public Build(@Nullable List<Plugin> plugins, @Nullable PluginManagement pluginManagement) {
            this.plugins = plugins;
            this.pluginManagement = pluginManagement;
        }
    }

    public static class PluginManagement {
        @Nullable
        @JacksonXmlElementWrapper(localName="plugins")
        @JacksonXmlProperty(localName="plugin")
        private List<Plugin> plugins;

        @Generated
        public PluginManagement() {
        }

        @Nullable
        @Generated
        public List<Plugin> getPlugins() {
            return this.plugins;
        }

        @JacksonXmlElementWrapper(localName="plugins")
        @JacksonXmlProperty(localName="plugin")
        @Generated
        public void setPlugins(@Nullable List<Plugin> plugins) {
            this.plugins = plugins;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PluginManagement)) {
                return false;
            }
            PluginManagement other = (PluginManagement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Plugin> this$plugins = this.getPlugins();
            List<Plugin> other$plugins = other.getPlugins();
            return !(this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PluginManagement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Plugin> $plugins = this.getPlugins();
            result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.PluginManagement(plugins=" + this.getPlugins() + ")";
        }
    }

    public static class License {
        private final String name;

        public License() {
            this.name = "";
        }

        public License(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.License(name=" + this.getName() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof License;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final ProfileActivation activation;
        @Nullable
        private final Map<String, String> properties;
        @Nullable
        private final Dependencies dependencies;
        @Nullable
        private final DependencyManagement dependencyManagement;
        @Nullable
        private final RawRepositories repositories;

        @Generated
        public Profile(@Nullable String id, @Nullable ProfileActivation activation, @Nullable Map<String, String> properties, @Nullable Dependencies dependencies, @Nullable DependencyManagement dependencyManagement, @Nullable RawRepositories repositories) {
            this.id = id;
            this.activation = activation;
            this.properties = properties;
            this.dependencies = dependencies;
            this.dependencyManagement = dependencyManagement;
            this.repositories = repositories;
        }

        @Nullable
        @Generated
        public String getId() {
            return this.id;
        }

        @Nullable
        @Generated
        public ProfileActivation getActivation() {
            return this.activation;
        }

        @Nullable
        @Generated
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Nullable
        @Generated
        public Dependencies getDependencies() {
            return this.dependencies;
        }

        @Nullable
        @Generated
        public DependencyManagement getDependencyManagement() {
            return this.dependencyManagement;
        }

        @Nullable
        @Generated
        public RawRepositories getRepositories() {
            return this.repositories;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            Dependencies this$dependencies = this.getDependencies();
            Dependencies other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
                return false;
            }
            DependencyManagement this$dependencyManagement = this.getDependencyManagement();
            DependencyManagement other$dependencyManagement = other.getDependencyManagement();
            if (this$dependencyManagement == null ? other$dependencyManagement != null : !this$dependencyManagement.equals(other$dependencyManagement)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Profile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            Dependencies $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
            DependencyManagement $dependencyManagement = this.getDependencyManagement();
            result = result * 59 + ($dependencyManagement == null ? 43 : $dependencyManagement.hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", properties=" + this.getProperties() + ", dependencies=" + this.getDependencies() + ", dependencyManagement=" + this.getDependencyManagement() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class Dependency {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;
        @Nullable
        private final String scope;
        @Nullable
        private final String type;
        @Nullable
        private final String classifier;
        @Nullable
        private final String optional;
        @Nullable
        @JacksonXmlElementWrapper
        private final List<GroupArtifact> exclusions;

        @Generated
        public Dependency(String groupId, String artifactId, @Nullable String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String optional, @Nullable List<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.scope = scope;
            this.type = type;
            this.classifier = classifier;
            this.optional = optional;
            this.exclusions = exclusions;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        @Generated
        public String getVersion() {
            return this.version;
        }

        @Nullable
        @Generated
        public String getScope() {
            return this.scope;
        }

        @Nullable
        @Generated
        public String getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public String getClassifier() {
            return this.classifier;
        }

        @Nullable
        @Generated
        public String getOptional() {
            return this.optional;
        }

        @Nullable
        @Generated
        public List<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$optional = this.getOptional();
            String other$optional = other.getOptional();
            if (this$optional == null ? other$optional != null : !this$optional.equals(other$optional)) {
                return false;
            }
            List<GroupArtifact> this$exclusions = this.getExclusions();
            List<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $optional = this.getOptional();
            result = result * 59 + ($optional == null ? 43 : $optional.hashCode());
            List<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", optional=" + this.getOptional() + ", exclusions=" + this.getExclusions() + ")";
        }
    }

    public static class Plugin {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;
        @Nullable
        private final String extensions;
        @Nullable
        private final String inherited;
        @Nullable
        private final JsonNode configuration;
        @Nullable
        @JacksonXmlElementWrapper(localName="dependencies")
        @JacksonXmlProperty(localName="dependency")
        private List<Dependency> dependencies;
        @Nullable
        @JacksonXmlElementWrapper(localName="executions")
        @JacksonXmlProperty(localName="execution")
        private List<Execution> executions;

        @Generated
        public Plugin(String groupId, String artifactId, @Nullable String version, @Nullable String extensions, @Nullable String inherited, @Nullable JsonNode configuration) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.extensions = extensions;
            this.inherited = inherited;
            this.configuration = configuration;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        @Generated
        public String getVersion() {
            return this.version;
        }

        @Nullable
        @Generated
        public String getExtensions() {
            return this.extensions;
        }

        @Nullable
        @Generated
        public String getInherited() {
            return this.inherited;
        }

        @Nullable
        @Generated
        public JsonNode getConfiguration() {
            return this.configuration;
        }

        @Nullable
        @Generated
        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Nullable
        @Generated
        public List<Execution> getExecutions() {
            return this.executions;
        }

        @JacksonXmlElementWrapper(localName="dependencies")
        @JacksonXmlProperty(localName="dependency")
        @Generated
        public void setDependencies(@Nullable List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        @JacksonXmlElementWrapper(localName="executions")
        @JacksonXmlProperty(localName="execution")
        @Generated
        public void setExecutions(@Nullable List<Execution> executions) {
            this.executions = executions;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plugin)) {
                return false;
            }
            Plugin other = (Plugin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$extensions = this.getExtensions();
            String other$extensions = other.getExtensions();
            if (this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions)) {
                return false;
            }
            String this$inherited = this.getInherited();
            String other$inherited = other.getInherited();
            if (this$inherited == null ? other$inherited != null : !this$inherited.equals(other$inherited)) {
                return false;
            }
            JsonNode this$configuration = this.getConfiguration();
            JsonNode other$configuration = other.getConfiguration();
            if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            List<Execution> this$executions = this.getExecutions();
            List<Execution> other$executions = other.getExecutions();
            return !(this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Plugin;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $extensions = this.getExtensions();
            result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
            String $inherited = this.getInherited();
            result = result * 59 + ($inherited == null ? 43 : $inherited.hashCode());
            JsonNode $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            List<Execution> $executions = this.getExecutions();
            result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Plugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", extensions=" + this.getExtensions() + ", inherited=" + this.getInherited() + ", configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", executions=" + this.getExecutions() + ")";
        }
    }

    public static class Execution {
        private final String id;
        @JacksonXmlElementWrapper(localName="goals")
        @JacksonXmlProperty(localName="goal")
        private List<String> goals;
        private final String phase;
        @Nullable
        private final String inherited;
        @Nullable
        private final JsonNode configuration;

        @Generated
        public Execution(String id, String phase, @Nullable String inherited, @Nullable JsonNode configuration) {
            this.id = id;
            this.phase = phase;
            this.inherited = inherited;
            this.configuration = configuration;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public List<String> getGoals() {
            return this.goals;
        }

        @Generated
        public String getPhase() {
            return this.phase;
        }

        @Nullable
        @Generated
        public String getInherited() {
            return this.inherited;
        }

        @Nullable
        @Generated
        public JsonNode getConfiguration() {
            return this.configuration;
        }

        @JacksonXmlElementWrapper(localName="goals")
        @JacksonXmlProperty(localName="goal")
        @Generated
        public void setGoals(List<String> goals) {
            this.goals = goals;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Execution)) {
                return false;
            }
            Execution other = (Execution)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$goals = this.getGoals();
            List<String> other$goals = other.getGoals();
            if (this$goals == null ? other$goals != null : !((Object)this$goals).equals(other$goals)) {
                return false;
            }
            String this$phase = this.getPhase();
            String other$phase = other.getPhase();
            if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
                return false;
            }
            String this$inherited = this.getInherited();
            String other$inherited = other.getInherited();
            if (this$inherited == null ? other$inherited != null : !this$inherited.equals(other$inherited)) {
                return false;
            }
            JsonNode this$configuration = this.getConfiguration();
            JsonNode other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Execution;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $goals = this.getGoals();
            result = result * 59 + ($goals == null ? 43 : ((Object)$goals).hashCode());
            String $phase = this.getPhase();
            result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
            String $inherited = this.getInherited();
            result = result * 59 + ($inherited == null ? 43 : $inherited.hashCode());
            JsonNode $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RawPom.Execution(id=" + this.getId() + ", goals=" + this.getGoals() + ", phase=" + this.getPhase() + ", inherited=" + this.getInherited() + ", configuration=" + this.getConfiguration() + ")";
        }
    }
}

