/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.trait;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.trait.MavenTraitMatcher;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.trait.Trait;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class MavenDependency
implements Trait<Xml.Tag> {
    private static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    private static final XPathMatcher PROFILE_DEPENDENCY_MATCHER = new XPathMatcher("/project/profiles/profile/dependencies/dependency");
    private final Cursor cursor;
    private final ResolvedDependency resolvedDependency;

    @Generated
    public MavenDependency(Cursor cursor, ResolvedDependency resolvedDependency) {
        this.cursor = cursor;
        this.resolvedDependency = resolvedDependency;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenDependency)) {
            return false;
        }
        MavenDependency other = (MavenDependency)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        ResolvedDependency this$resolvedDependency = this.getResolvedDependency();
        ResolvedDependency other$resolvedDependency = other.getResolvedDependency();
        return !(this$resolvedDependency == null ? other$resolvedDependency != null : !((Object)this$resolvedDependency).equals(other$resolvedDependency));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        ResolvedDependency $resolvedDependency = this.getResolvedDependency();
        result = result * 59 + ($resolvedDependency == null ? 43 : ((Object)$resolvedDependency).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenDependency(cursor=" + this.getCursor() + ", resolvedDependency=" + this.getResolvedDependency() + ")";
    }

    @Generated
    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    public static class Matcher
    extends MavenTraitMatcher<MavenDependency> {
        @Nullable
        protected String groupId;
        @Nullable
        protected String artifactId;

        public Matcher groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Matcher artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nullable
        protected MavenDependency test(Cursor cursor) {
            Object value = cursor.getValue();
            if (value instanceof Xml.Tag) {
                Xml.Tag tag = (Xml.Tag)value;
                if (!"dependency".equals(tag.getName()) || !DEPENDENCY_MATCHER.matches(cursor) && !PROFILE_DEPENDENCY_MATCHER.matches(cursor)) {
                    return null;
                }
                Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult(cursor).getDependencies();
                for (Scope scope : Scope.values()) {
                    if (!dependencies.containsKey((Object)scope)) continue;
                    for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                        Dependency req;
                        String reqGroup;
                        Scope tagScope;
                        if (this.groupId != null && !StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)this.groupId) || this.artifactId != null && !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)this.artifactId)) continue;
                        String scopeName = tag.getChildValue("scope").orElse(null);
                        Scope scope2 = tagScope = scopeName != null ? Scope.fromName(scopeName) : null;
                        if (tagScope == null && this.artifactId != null) {
                            tagScope = this.getResolutionResult(cursor).getPom().getManagedScope(this.groupId, this.artifactId, tag.getChildValue("type").orElse(null), tag.getChildValue("classifier").orElse(null));
                        }
                        if (tagScope == null) {
                            tagScope = Scope.Compile;
                        }
                        if ((reqGroup = (req = resolvedDependency.getRequested()).getGroupId()) != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || scope != tagScope) continue;
                        return new MavenDependency(cursor, resolvedDependency);
                    }
                }
            }
            return null;
        }
    }
}

