/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.VersionRequirement;

public class ProfileActivation {
    @Nullable
    private final Boolean activeByDefault;
    @Nullable
    private final String jdk;
    @Nullable
    private final Property property;

    public static boolean isActive(@Nullable String id, Iterable<String> activeProfiles, @Nullable ProfileActivation activation) {
        if (id != null) {
            for (String activeProfile : activeProfiles) {
                if (!activeProfile.trim().equals(id)) continue;
                return true;
            }
        }
        return activation != null && (activation.isActive() || Boolean.TRUE.equals(activation.getActiveByDefault()) && !activeProfiles.iterator().hasNext());
    }

    public boolean isActive() {
        return this.isActiveByJdk() || this.isActiveByProperty();
    }

    private boolean isActiveByJdk() {
        if (this.jdk == null) {
            return false;
        }
        String version = System.getProperty("java.version");
        if (version.startsWith(this.jdk)) {
            return true;
        }
        try {
            return version.equals(VersionRequirement.fromVersion(this.jdk, 0).resolve(() -> Collections.singletonList(version)));
        }
        catch (MavenDownloadingException e) {
            return false;
        }
    }

    private boolean isActiveByProperty() {
        if (this.property == null) {
            return false;
        }
        String name = this.property.getName().trim();
        if (name.startsWith("!")) {
            return !System.getenv().containsKey(name.replace("!", ""));
        }
        if (this.property.getValue() == null) {
            return System.getenv().containsKey(name);
        }
        return this.property.getValue().equals(System.getenv(name));
    }

    @Generated
    public ProfileActivation(@Nullable Boolean activeByDefault, @Nullable String jdk, @Nullable Property property) {
        this.activeByDefault = activeByDefault;
        this.jdk = jdk;
        this.property = property;
    }

    @Nullable
    @Generated
    public Boolean getActiveByDefault() {
        return this.activeByDefault;
    }

    @Nullable
    @Generated
    public String getJdk() {
        return this.jdk;
    }

    @Nullable
    @Generated
    public Property getProperty() {
        return this.property;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileActivation)) {
            return false;
        }
        ProfileActivation other = (ProfileActivation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$activeByDefault = this.getActiveByDefault();
        Boolean other$activeByDefault = other.getActiveByDefault();
        if (this$activeByDefault == null ? other$activeByDefault != null : !((Object)this$activeByDefault).equals(other$activeByDefault)) {
            return false;
        }
        String this$jdk = this.getJdk();
        String other$jdk = other.getJdk();
        if (this$jdk == null ? other$jdk != null : !this$jdk.equals(other$jdk)) {
            return false;
        }
        Property this$property = this.getProperty();
        Property other$property = other.getProperty();
        return !(this$property == null ? other$property != null : !((Object)this$property).equals(other$property));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProfileActivation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $activeByDefault = this.getActiveByDefault();
        result = result * 59 + ($activeByDefault == null ? 43 : ((Object)$activeByDefault).hashCode());
        String $jdk = this.getJdk();
        result = result * 59 + ($jdk == null ? 43 : $jdk.hashCode());
        Property $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ProfileActivation(activeByDefault=" + this.getActiveByDefault() + ", jdk=" + this.getJdk() + ", property=" + this.getProperty() + ")";
    }

    public static class Property {
        private final String name;
        @Nullable
        private final String value;

        @Generated
        public Property(String name, @Nullable String value) {
            this.name = name;
            this.value = value;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Property;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ProfileActivation.Property(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }
}

