package org.openqa.selenium.devtools.v117.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue tracks client hints related issues. It's used to deprecate old
 * features, encourage the use of new ones, and provide general guidance.
 */
public class ClientHintIssueDetails {

    private final org.openqa.selenium.devtools.v117.audits.model.SourceCodeLocation sourceCodeLocation;

    private final org.openqa.selenium.devtools.v117.audits.model.ClientHintIssueReason clientHintIssueReason;

    public ClientHintIssueDetails(org.openqa.selenium.devtools.v117.audits.model.SourceCodeLocation sourceCodeLocation, org.openqa.selenium.devtools.v117.audits.model.ClientHintIssueReason clientHintIssueReason) {
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.clientHintIssueReason = java.util.Objects.requireNonNull(clientHintIssueReason, "clientHintIssueReason is required");
    }

    public org.openqa.selenium.devtools.v117.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    public org.openqa.selenium.devtools.v117.audits.model.ClientHintIssueReason getClientHintIssueReason() {
        return clientHintIssueReason;
    }

    private static ClientHintIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v117.audits.model.SourceCodeLocation sourceCodeLocation = null;
        org.openqa.selenium.devtools.v117.audits.model.ClientHintIssueReason clientHintIssueReason = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v117.audits.model.SourceCodeLocation.class);
                    break;
                case "clientHintIssueReason":
                    clientHintIssueReason = input.read(org.openqa.selenium.devtools.v117.audits.model.ClientHintIssueReason.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ClientHintIssueDetails(sourceCodeLocation, clientHintIssueReason);
    }
}
