package org.openqa.selenium.devtools.v118.fedcm;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the FedCM dialog.
 */
@Beta()
public class FedCm {

    public static Command<Void> enable(java.util.Optional<java.lang.Boolean> disableRejectionDelay) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        disableRejectionDelay.ifPresent(p -> params.put("disableRejectionDelay", p));
        return new Command<>("FedCm.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("FedCm.disable", params.build());
    }

    public static Command<Void> selectAccount(java.lang.String dialogId, java.lang.Integer accountIndex) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        java.util.Objects.requireNonNull(accountIndex, "accountIndex is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        return new Command<>("FedCm.selectAccount", params.build());
    }

    /**
     * Only valid if the dialog type is ConfirmIdpSignin. Acts as if the user had
     * clicked the continue button.
     */
    public static Command<Void> confirmIdpSignin(java.lang.String dialogId) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("dialogId", dialogId);
        return new Command<>("FedCm.confirmIdpSignin", params.build());
    }

    public static Command<Void> dismissDialog(java.lang.String dialogId, java.util.Optional<java.lang.Boolean> triggerCooldown) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("dialogId", dialogId);
        triggerCooldown.ifPresent(p -> params.put("triggerCooldown", p));
        return new Command<>("FedCm.dismissDialog", params.build());
    }

    /**
     * Resets the cooldown time, if any, to allow the next FedCM call to show
     * a dialog even if one was recently dismissed by the user.
     */
    public static Command<Void> resetCooldown() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("FedCm.resetCooldown", params.build());
    }

    public static Event<org.openqa.selenium.devtools.v118.fedcm.model.DialogShown> dialogShown() {
        return new Event<>("FedCm.dialogShown", input -> input.read(org.openqa.selenium.devtools.v118.fedcm.model.DialogShown.class));
    }
}
