/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v118.network.model.BlockedCookieWithReason;
import org.openqa.selenium.devtools.v118.network.model.ClientSecurityState;
import org.openqa.selenium.devtools.v118.network.model.ConnectTiming;
import org.openqa.selenium.devtools.v118.network.model.Headers;
import org.openqa.selenium.devtools.v118.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestWillBeSentExtraInfo {
    private final RequestId requestId;
    private final List<BlockedCookieWithReason> associatedCookies;
    private final Headers headers;
    private final ConnectTiming connectTiming;
    private final Optional<ClientSecurityState> clientSecurityState;
    private final Optional<Boolean> siteHasCookieInOtherPartition;

    public RequestWillBeSentExtraInfo(RequestId requestId, List<BlockedCookieWithReason> associatedCookies, Headers headers, ConnectTiming connectTiming, Optional<ClientSecurityState> clientSecurityState, Optional<Boolean> siteHasCookieInOtherPartition) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.connectTiming = Objects.requireNonNull(connectTiming, "connectTiming is required");
        this.clientSecurityState = clientSecurityState;
        this.siteHasCookieInOtherPartition = siteHasCookieInOtherPartition;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedCookieWithReason> getAssociatedCookies() {
        return this.associatedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    @Beta
    public ConnectTiming getConnectTiming() {
        return this.connectTiming;
    }

    public Optional<ClientSecurityState> getClientSecurityState() {
        return this.clientSecurityState;
    }

    public Optional<Boolean> getSiteHasCookieInOtherPartition() {
        return this.siteHasCookieInOtherPartition;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List associatedCookies = null;
        Headers headers = null;
        ConnectTiming connectTiming = null;
        Optional<ClientSecurityState> clientSecurityState = Optional.empty();
        Optional<Boolean> siteHasCookieInOtherPartition = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "associatedCookies": {
                    associatedCookies = (List)input.read(new TypeToken<List<BlockedCookieWithReason>>(){}.getType());
                    continue block16;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block16;
                }
                case "connectTiming": {
                    connectTiming = (ConnectTiming)input.read(ConnectTiming.class);
                    continue block16;
                }
                case "clientSecurityState": {
                    clientSecurityState = Optional.ofNullable((ClientSecurityState)input.read(ClientSecurityState.class));
                    continue block16;
                }
                case "siteHasCookieInOtherPartition": {
                    siteHasCookieInOtherPartition = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers, connectTiming, clientSecurityState, siteHasCookieInOtherPartition);
    }
}

