package org.openqa.selenium.devtools.v137.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a cookie that is affected by an inspector issue.
 */
public class AffectedCookie {

    private final java.lang.String name;

    private final java.lang.String path;

    private final java.lang.String domain;

    public AffectedCookie(java.lang.String name, java.lang.String path, java.lang.String domain) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.path = java.util.Objects.requireNonNull(path, "path is required");
        this.domain = java.util.Objects.requireNonNull(domain, "domain is required");
    }

    /**
     * The following three properties uniquely identify a cookie
     */
    public java.lang.String getName() {
        return name;
    }

    public java.lang.String getPath() {
        return path;
    }

    public java.lang.String getDomain() {
        return domain;
    }

    private static AffectedCookie fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String path = null;
        java.lang.String domain = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "path":
                    path = input.nextString();
                    break;
                case "domain":
                    domain = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AffectedCookie(name, path, domain);
    }
}
