package org.openqa.selenium.devtools.v138.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ProtocolHandler {

    private final java.lang.String protocol;

    private final java.lang.String url;

    public ProtocolHandler(java.lang.String protocol, java.lang.String url) {
        this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
    }

    public java.lang.String getProtocol() {
        return protocol;
    }

    public java.lang.String getUrl() {
        return url;
    }

    private static ProtocolHandler fromJson(JsonInput input) {
        java.lang.String protocol = null;
        java.lang.String url = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "protocol":
                    protocol = input.nextString();
                    break;
                case "url":
                    url = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ProtocolHandler(protocol, url);
    }
}
