package org.openqa.selenium.devtools.v139.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A structure to hold the top-level node of a detached tree and an array of its retained descendants.
 */
public class DetachedElementInfo {

    private final org.openqa.selenium.devtools.v139.dom.model.Node treeNode;

    private final java.util.List<org.openqa.selenium.devtools.v139.dom.model.NodeId> retainedNodeIds;

    public DetachedElementInfo(org.openqa.selenium.devtools.v139.dom.model.Node treeNode, java.util.List<org.openqa.selenium.devtools.v139.dom.model.NodeId> retainedNodeIds) {
        this.treeNode = java.util.Objects.requireNonNull(treeNode, "treeNode is required");
        this.retainedNodeIds = java.util.Objects.requireNonNull(retainedNodeIds, "retainedNodeIds is required");
    }

    public org.openqa.selenium.devtools.v139.dom.model.Node getTreeNode() {
        return treeNode;
    }

    public java.util.List<org.openqa.selenium.devtools.v139.dom.model.NodeId> getRetainedNodeIds() {
        return retainedNodeIds;
    }

    private static DetachedElementInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v139.dom.model.Node treeNode = null;
        java.util.List<org.openqa.selenium.devtools.v139.dom.model.NodeId> retainedNodeIds = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "treeNode":
                    treeNode = input.read(org.openqa.selenium.devtools.v139.dom.model.Node.class);
                    break;
                case "retainedNodeIds":
                    retainedNodeIds = input.readArray(org.openqa.selenium.devtools.v139.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DetachedElementInfo(treeNode, retainedNodeIds);
    }
}
