/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultFieldSet
implements FieldSet {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private String grouping;
    private String decimal;
    private final String[] tokens;
    private List<String> names;

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        if (numberFormat instanceof DecimalFormat) {
            this.grouping = String.valueOf(((DecimalFormat)numberFormat).getDecimalFormatSymbols().getGroupingSeparator());
            this.decimal = String.valueOf(((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator());
        }
    }

    private static NumberFormat getDefaultNumberFormat() {
        return NumberFormat.getInstance(Locale.US);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private static DateFormat getDefaultDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public DefaultFieldSet(String[] tokens, @Nullable DateFormat dateFormat, @Nullable NumberFormat numberFormat) {
        this.tokens = tokens == null ? null : (String[])tokens.clone();
        this.setDateFormat(dateFormat == null ? DefaultFieldSet.getDefaultDateFormat() : dateFormat);
        this.setNumberFormat(numberFormat == null ? DefaultFieldSet.getDefaultNumberFormat() : numberFormat);
    }

    public DefaultFieldSet(String[] tokens) {
        this(tokens, null, null);
    }

    public DefaultFieldSet(String[] tokens, String[] names, @Nullable DateFormat dateFormat, @Nullable NumberFormat numberFormat) {
        Assert.notNull((Object)tokens, (String)"Tokens must not be null");
        Assert.notNull((Object)names, (String)"Names must not be null");
        if (tokens.length != names.length) {
            throw new IllegalArgumentException("Field names must be same length as values: names=" + String.valueOf(Arrays.asList(names)) + ", values=" + String.valueOf(Arrays.asList(tokens)));
        }
        this.tokens = (String[])tokens.clone();
        this.names = Arrays.asList(names);
        this.setDateFormat(dateFormat == null ? DefaultFieldSet.getDefaultDateFormat() : dateFormat);
        this.setNumberFormat(numberFormat == null ? DefaultFieldSet.getDefaultNumberFormat() : numberFormat);
    }

    public DefaultFieldSet(String[] tokens, String[] names) {
        this(tokens, names, null, null);
    }

    @Override
    public String[] getNames() {
        if (this.names == null) {
            throw new IllegalStateException("Field names are not known");
        }
        return this.names.toArray(new String[0]);
    }

    @Override
    public boolean hasNames() {
        return this.names != null;
    }

    @Override
    public String[] getValues() {
        return (String[])this.tokens.clone();
    }

    @Override
    public String readString(int index) {
        return this.readAndTrim(index);
    }

    @Override
    public String readString(String name) {
        return this.readString(this.indexOf(name));
    }

    @Override
    public String readRawString(int index) {
        return this.tokens[index];
    }

    @Override
    public String readRawString(String name) {
        return this.readRawString(this.indexOf(name));
    }

    @Override
    public boolean readBoolean(int index) {
        return this.readBoolean(index, "true");
    }

    @Override
    public boolean readBoolean(String name) {
        return this.readBoolean(this.indexOf(name));
    }

    @Override
    public boolean readBoolean(int index, String trueValue) {
        Assert.notNull((Object)trueValue, (String)"'trueValue' cannot be null.");
        String value = this.readAndTrim(index);
        return trueValue.equals(value);
    }

    @Override
    public boolean readBoolean(String name, String trueValue) {
        return this.readBoolean(this.indexOf(name), trueValue);
    }

    @Override
    public char readChar(int index) {
        String value = this.readAndTrim(index);
        Assert.isTrue((value.length() == 1 ? 1 : 0) != 0, (String)("Cannot convert field value '" + value + "' to char."));
        return value.charAt(0);
    }

    @Override
    public char readChar(String name) {
        return this.readChar(this.indexOf(name));
    }

    @Override
    public byte readByte(int index) {
        return Byte.parseByte(this.readAndTrim(index));
    }

    @Override
    public byte readByte(String name) {
        return this.readByte(this.indexOf(name));
    }

    @Override
    public short readShort(int index) {
        return Short.parseShort(this.readAndTrim(index));
    }

    @Override
    public short readShort(String name) {
        return this.readShort(this.indexOf(name));
    }

    @Override
    public int readInt(int index) {
        return this.parseNumber(this.readAndTrim(index)).intValue();
    }

    @Override
    public int readInt(String name) {
        return this.readInt(this.indexOf(name));
    }

    @Override
    public int readInt(int index, int defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Integer.parseInt(value) : defaultValue;
    }

    @Override
    public int readInt(String name, int defaultValue) {
        return this.readInt(this.indexOf(name), defaultValue);
    }

    @Override
    public long readLong(int index) {
        return this.parseNumber(this.readAndTrim(index)).longValue();
    }

    @Override
    public long readLong(String name) {
        return this.readLong(this.indexOf(name));
    }

    @Override
    public long readLong(int index, long defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Long.parseLong(value) : defaultValue;
    }

    @Override
    public long readLong(String name, long defaultValue) {
        return this.readLong(this.indexOf(name), defaultValue);
    }

    @Override
    public float readFloat(int index) {
        return this.parseNumber(this.readAndTrim(index)).floatValue();
    }

    @Override
    public float readFloat(String name) {
        return this.readFloat(this.indexOf(name));
    }

    @Override
    public double readDouble(int index) {
        return this.parseNumber(this.readAndTrim(index)).doubleValue();
    }

    @Override
    public double readDouble(String name) {
        return this.readDouble(this.indexOf(name));
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        return this.readBigDecimal(index, null);
    }

    @Override
    public BigDecimal readBigDecimal(String name) {
        return this.readBigDecimal(name, null);
    }

    @Override
    public BigDecimal readBigDecimal(int index, BigDecimal defaultValue) {
        String candidate = this.readAndTrim(index);
        if (!StringUtils.hasText((String)candidate)) {
            return defaultValue;
        }
        try {
            String result = this.removeSeparators(candidate);
            return new BigDecimal(result);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Unparseable number: " + candidate);
        }
    }

    private String removeSeparators(String candidate) {
        return candidate.replace(this.grouping, "").replace(this.decimal, ".");
    }

    @Override
    public BigDecimal readBigDecimal(String name, BigDecimal defaultValue) {
        try {
            return this.readBigDecimal(this.indexOf(name), defaultValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage() + ", name: [" + name + "]");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(int index) {
        return this.parseDate(this.readAndTrim(index), this.dateFormat);
    }

    @Override
    public Date readDate(int index, Date defaultValue) {
        String candidate = this.readAndTrim(index);
        return StringUtils.hasText((String)candidate) ? this.parseDate(candidate, this.dateFormat) : defaultValue;
    }

    @Override
    public Date readDate(String name) {
        try {
            return this.readDate(this.indexOf(name));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(String name, Date defaultValue) {
        try {
            return this.readDate(this.indexOf(name), defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(int index, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return this.parseDate(this.readAndTrim(index), sdf);
    }

    @Override
    public Date readDate(int index, String pattern, Date defaultValue) {
        String candidate = this.readAndTrim(index);
        return StringUtils.hasText((String)candidate) ? this.readDate(index, pattern) : defaultValue;
    }

    @Override
    public Date readDate(String name, String pattern) {
        try {
            return this.readDate(this.indexOf(name), pattern);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(String name, String pattern, Date defaultValue) {
        try {
            return this.readDate(this.indexOf(name), pattern, defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public int getFieldCount() {
        return this.tokens.length;
    }

    @Nullable
    protected String readAndTrim(int index) {
        String value = this.tokens[index];
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    protected int indexOf(String name) {
        if (this.names == null) {
            throw new IllegalArgumentException("Cannot access columns by name without meta data");
        }
        int index = this.names.indexOf(name);
        if (index >= 0) {
            return index;
        }
        throw new IllegalArgumentException("Cannot access column [" + name + "] from " + String.valueOf(this.names));
    }

    public String toString() {
        if (this.names != null) {
            return this.getProperties().toString();
        }
        return this.tokens == null ? "" : Arrays.asList(this.tokens).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultFieldSet) {
            DefaultFieldSet fs = (DefaultFieldSet)object;
            if (this.tokens == null) {
                return fs.tokens == null;
            }
            return Arrays.equals(this.tokens, fs.tokens);
        }
        return false;
    }

    public int hashCode() {
        if (this.tokens == null) {
            return 0;
        }
        int result = 1;
        for (String token : this.tokens) {
            result = 31 * result + (token == null ? 0 : token.hashCode());
        }
        return result;
    }

    @Override
    public Properties getProperties() {
        if (this.names == null) {
            throw new IllegalStateException("Cannot create properties without meta data");
        }
        Properties props = new Properties();
        for (int i = 0; i < this.tokens.length; ++i) {
            String value = this.readAndTrim(i);
            if (value == null) continue;
            props.setProperty(this.names.get(i), value);
        }
        return props;
    }

    private Number parseNumber(String candidate) {
        try {
            return this.numberFormat.parse(candidate);
        }
        catch (ParseException e) {
            throw new NumberFormatException("Unparseable number: " + candidate);
        }
    }

    private Date parseDate(String readAndTrim, DateFormat dateFormat) {
        try {
            return dateFormat.parse(readAndTrim);
        }
        catch (ParseException e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new IllegalArgumentException(e.getMessage() + ", format: [" + pattern + "]");
        }
    }
}

