/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.springframework.boot.loader.tools.LibraryCoordinates;

class ResolvedDependencies {
    private final Map<Configuration, ResolvedConfigurationDependencies> configurationDependencies = new LinkedHashMap<Configuration, ResolvedConfigurationDependencies>();

    ResolvedDependencies() {
    }

    private String projectId(Project project) {
        return project.getGroup() + ":" + project.getName() + ":" + project.getVersion();
    }

    void processConfiguration(Project project, Configuration configuration) {
        Set<String> localProjectIds = project.getRootProject().getAllprojects().stream().map(this::projectId).collect(Collectors.toSet());
        this.configurationDependencies.put(configuration, new ResolvedConfigurationDependencies(localProjectIds, configuration.getResolvedConfiguration()));
    }

    DependencyDescriptor find(File file) {
        for (ResolvedConfigurationDependencies dependencies : this.configurationDependencies.values()) {
            DependencyDescriptor dependency = dependencies.find(file);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    private static class ResolvedConfigurationDependencies {
        private final Map<File, DependencyDescriptor> dependencies = new LinkedHashMap<File, DependencyDescriptor>();

        ResolvedConfigurationDependencies(Set<String> projectDependencyIds, ResolvedConfiguration resolvedConfiguration) {
            if (!resolvedConfiguration.hasError()) {
                LenientConfiguration lenientConfiguration = resolvedConfiguration.getLenientConfiguration();
                lenientConfiguration.getFiles();
                for (ResolvedArtifact resolvedArtifact : lenientConfiguration.getArtifacts()) {
                    ModuleVersionIdentifier id = resolvedArtifact.getModuleVersion().getId();
                    boolean projectDependency = projectDependencyIds.contains(id.getGroup() + ":" + id.getName() + ":" + id.getVersion());
                    this.dependencies.put(resolvedArtifact.getFile(), new DependencyDescriptor(new ModuleVersionIdentifierLibraryCoordinates(id), projectDependency));
                }
            }
        }

        DependencyDescriptor find(File file) {
            return this.dependencies.get(file);
        }
    }

    static final class DependencyDescriptor {
        private final LibraryCoordinates coordinates;
        private final boolean projectDependency;

        private DependencyDescriptor(LibraryCoordinates coordinates, boolean projectDependency) {
            this.coordinates = coordinates;
            this.projectDependency = projectDependency;
        }

        LibraryCoordinates getCoordinates() {
            return this.coordinates;
        }

        boolean isProjectDependency() {
            return this.projectDependency;
        }
    }

    private static class ModuleVersionIdentifierLibraryCoordinates
    implements LibraryCoordinates {
        private final ModuleVersionIdentifier identifier;

        ModuleVersionIdentifierLibraryCoordinates(ModuleVersionIdentifier identifier) {
            this.identifier = identifier;
        }

        public String getGroupId() {
            return this.identifier.getGroup();
        }

        public String getArtifactId() {
            return this.identifier.getName();
        }

        public String getVersion() {
            return this.identifier.getVersion();
        }

        public String toString() {
            return this.identifier.toString();
        }
    }
}

