/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.context;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.ec2.AmazonEC2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.context.annotation.ConditionalOnAwsCloudEnvironment;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.context.config.annotation.ContextStackConfiguration;
import org.springframework.cloud.aws.core.env.stack.config.AutoDetectingStackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackResourceRegistryFactoryBean;
import org.springframework.cloud.aws.core.env.stack.config.StaticStackNameProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={ContextCredentialsAutoConfiguration.class, ContextDefaultConfigurationRegistrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.cloudformation.AmazonCloudFormation"})
public class ContextStackAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="cloud.aws", name={"stack.auto"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnAwsCloudEnvironment
    @ConditionalOnMissingBean(value={StackResourceRegistryFactoryBean.class})
    public static class StackAutoDetectConfiguration
    extends ContextStackConfiguration {
        @Autowired(required=false)
        private AmazonEC2 amazonEC2;

        @Bean
        public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new AutoDetectingStackNameProvider(amazonCloudFormation, this.amazonEC2));
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="cloud.aws", name={"stack.name"})
    public static class StackManualDetectConfiguration
    extends ContextStackConfiguration {
        @Autowired
        private Environment environment;

        @Bean
        public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new StaticStackNameProvider(this.environment.getProperty("cloud.aws.stack.name")));
        }
    }
}

