/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class SimpleFunctionRegistry
implements FunctionRegistry,
FunctionInspector {
    Log logger = LogFactory.getLog(SimpleFunctionRegistry.class);
    public static final String COULD_NOT_CONVERT_INPUT = "Could Not Convert Input";
    public static final String COULD_NOT_CONVERT_OUTPUT = "Could Not Convert Output";
    private final Map<Object, FunctionRegistration<Object>> registrationsByFunction = new HashMap<Object, FunctionRegistration<Object>>();
    private final Map<String, FunctionRegistration<Object>> registrationsByName = new HashMap<String, FunctionRegistration<Object>>();
    private final ConversionService conversionService;
    private final CompositeMessageConverter messageConverter;
    private List<String> declaredFunctionDefinitions;

    public SimpleFunctionRegistry(ConversionService conversionService, @Nullable CompositeMessageConverter messageConverter) {
        this.conversionService = conversionService;
        this.messageConverter = messageConverter;
        this.init(System.getProperty("spring.cloud.function.definition"));
    }

    void init(String functionDefinition) {
        List<Object> list = this.declaredFunctionDefinitions = StringUtils.hasText((String)functionDefinition) ? Arrays.asList(functionDefinition.split(";")) : Collections.emptyList();
        if (this.declaredFunctionDefinitions.contains("functionRouter")) {
            Assert.isTrue((this.declaredFunctionDefinitions.size() == 1 ? 1 : 0) != 0, (String)"It is illegal to declare more then one function when using RoutingFunction");
        }
    }

    @Override
    public <T> T lookup(Class<?> type, String definition) {
        return this.lookup(definition, new String[0]);
    }

    @Override
    public int size() {
        return this.registrationsByFunction.size();
    }

    @Override
    public <T> T lookup(String definition, String ... acceptedOutputTypes) {
        boolean routing;
        definition = StringUtils.hasText((String)definition) ? definition.replaceAll(",", "|") : "";
        boolean bl = routing = definition.contains("functionRouter") || this.declaredFunctionDefinitions.contains("functionRouter");
        if (!routing && this.declaredFunctionDefinitions.size() > 0) {
            if (StringUtils.hasText((String)definition)) {
                if (this.declaredFunctionDefinitions.size() > 1 && !this.declaredFunctionDefinitions.contains(definition)) {
                    this.logger.warn((Object)("Attempted to access un-declared function definition '" + definition + "'. Declared functions are '" + this.declaredFunctionDefinitions + "' specified via `spring.cloud.function.definition` property. If the intention is to access any function available in FunctionCatalog, please remove `spring.cloud.function.definition` property."));
                    return null;
                }
            } else if (this.declaredFunctionDefinitions.size() == 1) {
                definition = this.declaredFunctionDefinitions.get(0);
            } else {
                if (this.declaredFunctionDefinitions.size() > 1) {
                    this.logger.warn((Object)("Default function can not be mapped since multiple functions are declared " + this.declaredFunctionDefinitions));
                    return null;
                }
                this.logger.warn((Object)"Default function can not be mapped since multiple functions are available in FunctionCatalog. Please use 'spring.cloud.function.definition' property.");
                return null;
            }
        }
        FunctionInvocationWrapper function = (FunctionInvocationWrapper)this.compose(null, definition, acceptedOutputTypes);
        return (T)function;
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Set<String> registeredNames = this.registrationsByFunction.values().stream().flatMap(reg -> reg.getNames().stream()).collect(Collectors.toSet());
        return registeredNames;
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        this.registrationsByFunction.put(registration.getTarget(), registration);
        for (String name : registration.getNames()) {
            this.registrationsByName.put(name, registration);
        }
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        FunctionRegistration<Object> registration = this.registrationsByFunction.get(function);
        if (registration == null && function instanceof FunctionInvocationWrapper) {
            function = ((FunctionInvocationWrapper)function).target;
        }
        return this.registrationsByFunction.get(function);
    }

    Object locateFunction(String name) {
        return this.registrationsByName.get(name);
    }

    Type discoverFunctionType(Object function, String ... names) {
        if (function instanceof RoutingFunction) {
            return this.registrationsByName.get(names[0]).getType().getType();
        }
        return FunctionTypeUtils.discoverFunctionTypeFromClass(function.getClass());
    }

    String discoverDefaultDefinitionFromRegistration() {
        String definition = null;
        if (this.registrationsByName.size() > 0) {
            Assert.isTrue((this.registrationsByName.size() == 1 ? 1 : 0) != 0, (String)"Found more then one function in local registry");
            definition = this.registrationsByName.keySet().iterator().next();
        }
        return definition;
    }

    String discoverDefaultDefinitionIfNecessary(String definition) {
        if (StringUtils.isEmpty((Object)definition)) {
            definition = this.discoverDefaultDefinitionFromRegistration();
        } else if (!this.registrationsByName.containsKey(definition) && this.registrationsByName.size() == 1) {
            definition = this.registrationsByName.keySet().iterator().next();
        } else if (definition.endsWith("|") && this.registrationsByName.size() == 2) {
            Set<String> fNames = this.getNames(null);
            definition = this.determinImpliedDefinition(fNames, definition);
        }
        return definition;
    }

    String determinImpliedDefinition(Set<String> fNames, String originalDefinition) {
        if (fNames.size() == 2) {
            Iterator<String> iter = fNames.iterator();
            String n1 = iter.next();
            String n2 = iter.next();
            String[] definitionName = StringUtils.delimitedListToStringArray((String)originalDefinition, (String)"|");
            if (definitionName[0].equals(n1)) {
                definitionName[1] = n2;
                originalDefinition = definitionName[0] + "|" + definitionName[1];
            } else {
                definitionName[1] = n1;
                originalDefinition = definitionName[0] + "|" + definitionName[1];
            }
        }
        return originalDefinition;
    }

    Type discoverFunctionTypeByName(String name) {
        return this.registrationsByName.get(name).getType().getType();
    }

    private Function<?, ?> compose(Class<?> type, String definition, String ... acceptedOutputTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Looking up function '" + definition + "' with acceptedOutputTypes: " + Arrays.asList(acceptedOutputTypes)));
        }
        if (StringUtils.isEmpty((Object)(definition = this.discoverDefaultDefinitionIfNecessary(definition)))) {
            return null;
        }
        Function<Object, Object> resultFunction = null;
        if (this.registrationsByName.containsKey(definition)) {
            Object targetFunction = this.registrationsByName.get(definition).getTarget();
            Type functionType = this.registrationsByName.get(definition).getType().getType();
            resultFunction = new FunctionInvocationWrapper(targetFunction, functionType, definition, acceptedOutputTypes);
        } else {
            String[] names = StringUtils.delimitedListToStringArray((String)definition.replaceAll(",", "|").trim(), (String)"|");
            StringBuilder composedNameBuilder = new StringBuilder();
            String prefix = "";
            Type originFunctionType = null;
            for (String name : names) {
                FunctionRegistration<Object> registration;
                Object function = this.locateFunction(name);
                if (function == null) {
                    this.logger.debug((Object)("Failed to discover function '" + definition + "' in function catalog. Function available in catalog are: " + this.getNames(null) + ". This is generally acceptable for cases where there was no intention to use functions."));
                    return null;
                }
                Type functionType = this.discoverFunctionTypeByName(name);
                if (functionType != null && functionType.toString().contains("org.apache.kafka.streams.")) {
                    this.logger.debug((Object)("Kafka Streams function '" + definition + "' is not supported by spring-cloud-function."));
                    return null;
                }
                composedNameBuilder.append(prefix);
                composedNameBuilder.append(name);
                Type currentFunctionType = null;
                if (function instanceof FunctionRegistration) {
                    registration = (FunctionRegistration<Object>)function;
                    currentFunctionType = currentFunctionType == null ? registration.getType().getType() : currentFunctionType;
                    function = registration.getTarget();
                } else {
                    if (this.isFunctionPojo(function)) {
                        Method functionalMethod = FunctionTypeUtils.discoverFunctionalMethod(function.getClass());
                        currentFunctionType = FunctionTypeUtils.fromFunctionMethod(functionalMethod);
                        function = this.proxyTarget(function, functionalMethod);
                    }
                    String[] aliasNames = this.getAliases(name).toArray(new String[0]);
                    currentFunctionType = currentFunctionType == null ? this.discoverFunctionType(function, aliasNames) : currentFunctionType;
                    registration = new FunctionRegistration<Object>(function, name).type(currentFunctionType);
                }
                if (function instanceof RoutingFunction) {
                    this.registrationsByFunction.putIfAbsent(function, registration);
                    this.registrationsByName.putIfAbsent(name, registration);
                }
                function = new FunctionInvocationWrapper(function, currentFunctionType, name, names.length > 1 ? new String[]{} : acceptedOutputTypes);
                if (originFunctionType == null) {
                    originFunctionType = currentFunctionType;
                }
                if (resultFunction == null) {
                    resultFunction = (Function)function;
                } else {
                    originFunctionType = FunctionTypeUtils.compose(originFunctionType, currentFunctionType);
                    resultFunction = new FunctionInvocationWrapper(resultFunction.andThen((Function)function), originFunctionType, composedNameBuilder.toString(), acceptedOutputTypes);
                }
                prefix = "|";
            }
            ((FunctionInvocationWrapper)resultFunction).acceptedOutputMimeTypes = acceptedOutputTypes;
            FunctionRegistration<FunctionInvocationWrapper> registration = new FunctionRegistration<FunctionInvocationWrapper>((FunctionInvocationWrapper)resultFunction, definition).type(originFunctionType);
            this.registrationsByFunction.putIfAbsent(resultFunction, registration);
            this.registrationsByName.putIfAbsent(definition, registration);
        }
        return resultFunction;
    }

    private boolean isFunctionPojo(Object function) {
        return !function.getClass().isSynthetic() && !(function instanceof Supplier) && !(function instanceof Function) && !(function instanceof Consumer) && !function.getClass().getPackage().getName().startsWith("org.springframework.cloud.function.compiler");
    }

    private Object proxyTarget(Object targetFunction, final Method actualMethodToCall) {
        ProxyFactory pf = new ProxyFactory(targetFunction);
        pf.setProxyTargetClass(true);
        pf.setInterfaces(new Class[]{Function.class});
        pf.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                return actualMethodToCall.invoke(invocation.getThis(), invocation.getArguments());
            }
        });
        return pf.getProxy();
    }

    Collection<String> getAliases(String functionName) {
        return Collections.singletonList(functionName);
    }

    public class FunctionInvocationWrapper
    implements Function<Object, Object>,
    Consumer<Object>,
    Supplier<Object> {
        private final Object target;
        private final Type functionType;
        private final boolean composed;
        String[] acceptedOutputMimeTypes;
        private final String functionDefinition;
        private final Field headersField;

        FunctionInvocationWrapper(Object target, Type functionType, String functionDefinition, String ... acceptedOutputMimeTypes) {
            this.target = target;
            this.composed = functionDefinition.contains("|") || target instanceof RoutingFunction;
            this.functionType = functionType;
            this.acceptedOutputMimeTypes = acceptedOutputMimeTypes;
            this.functionDefinition = functionDefinition;
            this.headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
            this.headersField.setAccessible(true);
        }

        public String getFunctionDefinition() {
            return this.functionDefinition;
        }

        @Override
        public void accept(Object input) {
            this.doApply(input, true, null);
        }

        @Override
        public Object apply(Object input) {
            return this.apply(input, null);
        }

        public Object apply(Object input, Function<Message, Message> enricher) {
            return this.doApply(input, false, enricher);
        }

        @Override
        public Object get() {
            return this.get(null);
        }

        public Object get(Function<Message, Message> enricher) {
            Mono input = FunctionTypeUtils.isMono(this.functionType) ? Mono.empty() : (FunctionTypeUtils.isMono(this.functionType) ? Flux.empty() : null);
            return this.doApply(input, false, enricher);
        }

        public Type getFunctionType() {
            return this.functionType;
        }

        public boolean isConsumer() {
            return FunctionTypeUtils.isConsumer(this.functionType);
        }

        public boolean isSupplier() {
            return FunctionTypeUtils.isSupplier(this.functionType);
        }

        public Object getTarget() {
            return this.target;
        }

        public String toString() {
            return "definition: " + this.functionDefinition + "; type: " + this.functionType;
        }

        private Object invokeFunction(Object input) {
            Message incomingMessage = null;
            if (!this.functionDefinition.startsWith("functionRouter") && input instanceof Message && !FunctionTypeUtils.isMessage(FunctionTypeUtils.getInputType(this.functionType, 0)) && ((Message)input).getHeaders().containsKey((Object)"scf-func-name")) {
                incomingMessage = (Message)input;
                input = incomingMessage.getPayload();
            }
            Mono invocationResult = null;
            if (this.target instanceof Function) {
                invocationResult = (Mono)((Function)this.target).apply(input);
            } else if (this.target instanceof Supplier) {
                invocationResult = (Mono)((Supplier)this.target).get();
            } else if (input instanceof Flux) {
                invocationResult = ((Flux)input).transform(flux -> {
                    ((Consumer)this.target).accept(flux);
                    return Mono.ignoreElements((Publisher)((Flux)flux));
                }).then();
            } else if (input instanceof Mono) {
                invocationResult = ((Mono)input).transform(flux -> {
                    ((Consumer)this.target).accept(flux);
                    return Mono.ignoreElements((Publisher)((Mono)flux));
                }).then();
            } else {
                ((Consumer)this.target).accept(input);
            }
            if (!(this.target instanceof Consumer) && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Result of invocation of \"" + this.functionDefinition + "\" function is '" + invocationResult + "'"));
            }
            if (!(invocationResult instanceof Message) && incomingMessage != null && invocationResult != null && incomingMessage.getHeaders().containsKey((Object)"scf-func-name")) {
                invocationResult = MessageBuilder.withPayload((Object)invocationResult).copyHeaders((Map)incomingMessage.getHeaders()).removeHeader("contentType").build();
            }
            return invocationResult;
        }

        private Object doApply(Object input, boolean consumer, Function<Message, Message> enricher) {
            Object result;
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Applying function: " + this.functionDefinition));
            }
            if (input instanceof Publisher) {
                Publisher<?> publisher = input = this.composed ? input : this.convertInputPublisherIfNecessary((Publisher)input, FunctionTypeUtils.getInputType(this.functionType, 0));
                if (FunctionTypeUtils.isReactive(FunctionTypeUtils.getInputType(this.functionType, 0))) {
                    result = this.invokeFunction(input);
                } else {
                    if (this.composed) {
                        return input instanceof Mono ? Mono.from(input).transform((Function)this.target) : Flux.from(input).transform((Function)this.target);
                    }
                    result = FunctionTypeUtils.isConsumer(this.functionType) ? (input instanceof Mono ? Mono.from(input).doOnNext((Consumer)this.target).then() : Flux.from(input).doOnNext((Consumer)this.target).then()) : (input instanceof Mono ? Mono.from(input).map(value -> this.invokeFunction(value)) : Flux.from(input).map(value -> this.invokeFunction(value)));
                }
            } else {
                Type type = FunctionTypeUtils.getInputType(this.functionType, 0);
                if (!this.composed && !FunctionTypeUtils.isMultipleInputArguments(this.functionType) && FunctionTypeUtils.isReactive(type)) {
                    Flux publisher;
                    Flux flux = FunctionTypeUtils.isFlux(type) ? (input == null ? Flux.empty() : Flux.just(input)) : (publisher = input == null ? Mono.empty() : Mono.just(input));
                    if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Invoking reactive function '" + this.functionType + "' with non-reactive input should at least assume reactive output (e.g., Function<String, Flux<String>> f3 = catalog.lookup(\"echoFlux\");), otherwise invocation will result in ClassCastException."));
                    }
                    result = this.invokeFunction(this.convertInputPublisherIfNecessary((Publisher<?>)publisher, FunctionTypeUtils.getInputType(this.functionType, 0)));
                } else {
                    result = this.invokeFunction(this.composed ? input : (input == null ? input : this.convertInputValueIfNecessary(input, FunctionTypeUtils.getInputType(this.functionType, 0))));
                }
            }
            if (result != null && !ObjectUtils.isEmpty((Object[])this.acceptedOutputMimeTypes)) {
                result = result instanceof Publisher ? this.convertOutputPublisherIfNecessary((Publisher)result, enricher, this.acceptedOutputMimeTypes) : this.convertOutputValueIfNecessary(result, enricher, this.acceptedOutputMimeTypes);
            }
            return result;
        }

        private Object convertOutputValueIfNecessary(Object value, Function<Message, Message> enricher, String ... acceptedOutputMimeTypes) {
            SimpleFunctionRegistry.this.logger.debug((Object)"Applying type conversion on output value");
            List<Object> convertedValue = null;
            if (FunctionTypeUtils.isMultipleArgumentsHolder(value)) {
                int outputCount = FunctionTypeUtils.getOutputCount(this.functionType);
                Object[] convertedInputArray = new Object[outputCount];
                for (int i = 0; i < outputCount; ++i) {
                    Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                    Object outputArgument = parsed.getValue((Object)value);
                    try {
                        convertedInputArray[i] = outputArgument instanceof Publisher ? this.convertOutputPublisherIfNecessary((Publisher)outputArgument, enricher, acceptedOutputMimeTypes[i]) : this.convertOutputValueIfNecessary(outputArgument, enricher, acceptedOutputMimeTypes[i]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalStateException("The number of 'acceptedOutputMimeTypes' for function '" + this.functionDefinition + "' is (" + acceptedOutputMimeTypes.length + "), which does not match the number of actual outputs of this function which is (" + outputCount + ").", e);
                    }
                }
                convertedValue = Tuples.fromArray((Object[])convertedInputArray);
            } else {
                List acceptedContentTypes = MimeTypeUtils.parseMimeTypes((String)acceptedOutputMimeTypes[0].toString());
                if (CollectionUtils.isEmpty((Collection)acceptedContentTypes)) {
                    convertedValue = value;
                } else {
                    for (int i = 0; i < acceptedContentTypes.size() && convertedValue == null; ++i) {
                        MimeType acceptedContentType = (MimeType)acceptedContentTypes.get(i);
                        boolean convertIndividualItem = false;
                        if (value instanceof Iterable || ObjectUtils.isArray((Object)value) && !(value instanceof byte[])) {
                            Type outputType = FunctionTypeUtils.getOutputType(this.functionType, 0);
                            if (outputType instanceof ParameterizedType) {
                                convertIndividualItem = FunctionTypeUtils.isMessage(FunctionTypeUtils.getImmediateGenericType(outputType, 0));
                            } else if (outputType instanceof GenericArrayType) {
                                convertIndividualItem = FunctionTypeUtils.isMessage(((GenericArrayType)outputType).getGenericComponentType());
                            }
                        }
                        if (convertIndividualItem) {
                            if (ObjectUtils.isArray((Object)value)) {
                                value = Arrays.asList((Object[])value);
                            }
                            AtomicReference messages = new AtomicReference(new ArrayList());
                            ((Iterable)value).forEach(element -> ((List)messages.get()).add((Message)this.convertOutputValueIfNecessary(element, enricher, acceptedContentType.toString())));
                            convertedValue = messages.get();
                            continue;
                        }
                        convertedValue = this.convertValueToMessage(value, enricher, acceptedContentType);
                    }
                }
            }
            if (convertedValue == null) {
                throw new MessageConversionException(SimpleFunctionRegistry.COULD_NOT_CONVERT_OUTPUT);
            }
            return convertedValue;
        }

        private Message convertValueToMessage(Object value, Function<Message, Message> enricher, MimeType acceptedContentType) {
            Message outputMessage = null;
            if (value instanceof Message) {
                MessageHeaders headers = ((Message)value).getHeaders();
                Map headersMap = (Map)ReflectionUtils.getField((Field)this.headersField, (Object)headers);
                headersMap.put("accept", acceptedContentType);
                if (acceptedContentType.isConcrete()) {
                    headersMap.put("contentType", acceptedContentType);
                }
            } else {
                MessageBuilder builder = MessageBuilder.withPayload((Object)value).setHeader("accept", (Object)acceptedContentType);
                if (acceptedContentType.isConcrete()) {
                    builder.setHeader("contentType", (Object)acceptedContentType);
                }
                value = builder.build();
            }
            if (enricher != null) {
                value = enricher.apply((Message)value);
            }
            outputMessage = SimpleFunctionRegistry.this.messageConverter.toMessage(((Message)value).getPayload(), ((Message)value).getHeaders());
            return outputMessage;
        }

        private Publisher<?> convertOutputPublisherIfNecessary(Publisher<?> publisher, Function<Message, Message> enricher, String ... acceptedOutputMimeTypes) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Applying type conversion on output Publisher " + publisher));
            }
            Mono result = publisher instanceof Mono ? Mono.from(publisher).map(value -> this.convertOutputValueIfNecessary(value, enricher, acceptedOutputMimeTypes)) : Flux.from(publisher).map(value -> this.convertOutputValueIfNecessary(value, enricher, acceptedOutputMimeTypes));
            return result;
        }

        private Publisher<?> convertInputPublisherIfNecessary(Publisher<?> publisher, Type type) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Applying type conversion on input Publisher " + publisher));
            }
            Mono result = publisher instanceof Mono ? Mono.from(publisher).map(value -> this.convertInputValueIfNecessary(value, type)) : Flux.from(publisher).map(value -> this.convertInputValueIfNecessary(value, type));
            return result;
        }

        private Object convertInputValueIfNecessary(Object value, Type type) {
            Object convertedValue;
            block21: {
                if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                    SimpleFunctionRegistry.this.logger.debug((Object)("Applying type conversion on input value " + value));
                    SimpleFunctionRegistry.this.logger.debug((Object)("Function type: " + this.functionType));
                }
                convertedValue = value;
                if (FunctionTypeUtils.isMultipleArgumentsHolder(value)) {
                    int inputCount = FunctionTypeUtils.getInputCount(this.functionType);
                    Object[] convertedInputArray = new Object[inputCount];
                    for (int i = 0; i < inputCount; ++i) {
                        Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                        Publisher<?> inptArgument = parsed.getValue(value);
                        convertedInputArray[i] = inptArgument = inptArgument instanceof Publisher ? this.convertInputPublisherIfNecessary((Publisher)inptArgument, FunctionTypeUtils.getInputType(this.functionType, i)) : this.convertInputValueIfNecessary(inptArgument, FunctionTypeUtils.getInputType(this.functionType, i));
                    }
                    convertedValue = Tuples.fromArray((Object[])convertedInputArray);
                } else {
                    Type rawType = FunctionTypeUtils.unwrapActualTypeByIndex(type, 0);
                    if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Raw type of value: " + value + "is " + rawType));
                    }
                    if (rawType instanceof ParameterizedType) {
                        rawType = ((ParameterizedType)rawType).getRawType();
                    }
                    if (value != null && !(value instanceof Message) && FunctionTypeUtils.isMessage(type)) {
                        convertedValue = value = new GenericMessage(value);
                    }
                    if (value instanceof Message) {
                        if (this.messageNeedsConversion(rawType, (Message)value)) {
                            Object object = convertedValue = FunctionTypeUtils.isTypeCollection(type) ? SimpleFunctionRegistry.this.messageConverter.fromMessage((Message)value, (Class)rawType, (Object)FunctionTypeUtils.getGenericType(type)) : SimpleFunctionRegistry.this.messageConverter.fromMessage((Message)value, (Class)rawType);
                            if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                                SimpleFunctionRegistry.this.logger.debug((Object)("Converted from Message: " + convertedValue));
                            }
                            if (FunctionTypeUtils.isMessage(type) || ((Message)value).getHeaders().containsKey((Object)"scf-func-name")) {
                                convertedValue = MessageBuilder.withPayload((Object)convertedValue).copyHeaders((Map)((Message)value).getHeaders()).build();
                            }
                        } else if (!FunctionTypeUtils.isMessage(type)) {
                            convertedValue = ((Message)convertedValue).getPayload();
                        }
                    } else if (rawType instanceof Class) {
                        if (this.isJson(value)) {
                            convertedValue = SimpleFunctionRegistry.this.messageConverter.fromMessage((Message)new GenericMessage(value), (Class)rawType);
                        } else {
                            try {
                                convertedValue = SimpleFunctionRegistry.this.conversionService.convert(value, (Class)rawType);
                            }
                            catch (Exception e) {
                                if (!(value instanceof String) && !(value instanceof byte[])) break block21;
                                convertedValue = SimpleFunctionRegistry.this.messageConverter.fromMessage((Message)new GenericMessage(value), (Class)rawType);
                            }
                        }
                    }
                }
            }
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Converted input value " + convertedValue));
            }
            if (convertedValue == null) {
                throw new MessageConversionException(SimpleFunctionRegistry.COULD_NOT_CONVERT_INPUT);
            }
            return convertedValue;
        }

        private boolean isJson(Object value) {
            String v;
            String string = value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : (v = value instanceof String ? (String)value : null);
            return v != null && JsonMapper.isJsonString(v);
        }

        private boolean messageNeedsConversion(Type rawType, Message<?> message) {
            Boolean skipConversion;
            Boolean bl = skipConversion = message.getHeaders().containsKey((Object)"skip-type-conversion") ? (Boolean)message.getHeaders().get((Object)"skip-type-conversion", Boolean.class) : Boolean.valueOf(false);
            if (skipConversion.booleanValue()) {
                return false;
            }
            return rawType instanceof Class && !(message.getPayload() instanceof Optional) && !message.getPayload().getClass().isAssignableFrom((Class)rawType);
        }
    }
}

