/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.ValueFunction;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.domain.SqlSort;
import org.springframework.data.util.Pair;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryMapper {
    private final JdbcConverter converter;
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;

    @Deprecated(since="3.2")
    public QueryMapper(Dialect dialect, JdbcConverter converter) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public QueryMapper(JdbcConverter converter) {
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public List<OrderByField> getMappedSort(Table table, Sort sort, @Nullable RelationalPersistentEntity<?> entity) {
        ArrayList<OrderByField> mappedOrder = new ArrayList<OrderByField>();
        for (Sort.Order order : sort) {
            SqlSort.validate((Sort.Order)order);
            OrderByField simpleOrderByField = this.createSimpleOrderByField(table, entity, order);
            OrderByField orderBy = simpleOrderByField.withNullHandling(order.getNullHandling());
            mappedOrder.add(order.isAscending() ? orderBy.asc() : orderBy.desc());
        }
        return mappedOrder;
    }

    private OrderByField createSimpleOrderByField(Table table, RelationalPersistentEntity<?> entity, Sort.Order order) {
        SqlSort.SqlOrder sqlOrder;
        if (order instanceof SqlSort.SqlOrder && (sqlOrder = (SqlSort.SqlOrder)order).isUnsafe()) {
            return OrderByField.from((Expression)Expressions.just((String)sqlOrder.getProperty()));
        }
        Field field = this.createPropertyField(entity, SqlIdentifier.unquoted((String)order.getProperty()), this.mappingContext);
        return OrderByField.from((Expression)table.column(field.getMappedColumnName()));
    }

    Expression getMappedObject(Expression expression, @Nullable RelationalPersistentEntity<?> entity) {
        if (entity == null || expression instanceof AsteriskFromTable) {
            return expression;
        }
        if (expression instanceof Column) {
            Column column;
            Column column2 = (Column)expression;
            Field field = this.createPropertyField(entity, column2.getName());
            TableLike table = column2.getTable();
            Assert.state((table != null ? 1 : 0) != 0, (String)String.format("The column %s must have a table set", column2));
            Column columnFromTable = table.column(field.getMappedColumnName());
            if (column2 instanceof Aliased) {
                Aliased aliased = (Aliased)column2;
                column = columnFromTable.as(aliased.getAlias());
            } else {
                column = columnFromTable;
            }
            return column;
        }
        if (expression instanceof SimpleFunction) {
            SimpleFunction simpleFunction;
            SimpleFunction function = (SimpleFunction)expression;
            List arguments = function.getExpressions();
            ArrayList<Expression> mappedArguments = new ArrayList<Expression>(arguments.size());
            for (Expression argument : arguments) {
                mappedArguments.add(this.getMappedObject(argument, entity));
            }
            SimpleFunction mappedFunction = SimpleFunction.create((String)function.getFunctionName(), mappedArguments);
            if (function instanceof Aliased) {
                Aliased aliased = (Aliased)function;
                simpleFunction = mappedFunction.as(aliased.getAlias());
            } else {
                simpleFunction = mappedFunction;
            }
            return simpleFunction;
        }
        throw new IllegalArgumentException(String.format("Cannot map %s", expression));
    }

    public Condition getMappedObject(MapSqlParameterSource parameterSource, CriteriaDefinition criteria, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)parameterSource, (String)"MapSqlParameterSource must not be null");
        Assert.notNull((Object)criteria, (String)"CriteriaDefinition must not be null");
        Assert.notNull((Object)table, (String)"Table must not be null");
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Cannot map empty Criteria");
        }
        return this.unroll(criteria, table, entity, parameterSource);
    }

    private Condition unroll(CriteriaDefinition criteria, Table table, @Nullable RelationalPersistentEntity<?> entity, MapSqlParameterSource parameterSource) {
        CriteriaDefinition current = criteria;
        HashMap<CriteriaDefinition, CriteriaDefinition> forwardChain = new HashMap<CriteriaDefinition, CriteriaDefinition>();
        while (current.hasPrevious()) {
            forwardChain.put(current.getPrevious(), current);
            current = current.getPrevious();
        }
        Condition mapped = this.getCondition(current, parameterSource, table, entity);
        while (forwardChain.containsKey(current)) {
            CriteriaDefinition criterion = (CriteriaDefinition)forwardChain.get(current);
            Condition result = null;
            Condition condition = this.getCondition(criterion, parameterSource, table, entity);
            if (condition != null) {
                result = this.combine(mapped, criterion.getCombinator(), condition);
            }
            if (result != null) {
                mapped = result;
            }
            current = criterion;
        }
        if (mapped == null) {
            throw new IllegalStateException("Cannot map empty Criteria");
        }
        return mapped;
    }

    @Nullable
    private Condition unrollGroup(List<? extends CriteriaDefinition> criteria, Table table, CriteriaDefinition.Combinator combinator, @Nullable RelationalPersistentEntity<?> entity, MapSqlParameterSource parameterSource) {
        Condition mapped = null;
        for (CriteriaDefinition criteriaDefinition : criteria) {
            if (criteriaDefinition.isEmpty()) continue;
            Condition condition = this.unroll(criteriaDefinition, table, entity, parameterSource);
            mapped = this.combine(mapped, combinator, condition);
        }
        return mapped;
    }

    @Nullable
    private Condition getCondition(CriteriaDefinition criteria, MapSqlParameterSource parameterSource, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        if (criteria.isEmpty()) {
            return null;
        }
        if (criteria.isGroup()) {
            Condition condition = this.unrollGroup(criteria.getGroup(), table, criteria.getCombinator(), entity, parameterSource);
            return condition == null ? null : Conditions.nest((Condition)condition);
        }
        return this.mapCondition(criteria, parameterSource, table, entity);
    }

    private Condition combine(@Nullable Condition currentCondition, CriteriaDefinition.Combinator combinator, Condition nextCondition) {
        if (currentCondition == null) {
            currentCondition = nextCondition;
        } else if (combinator == CriteriaDefinition.Combinator.INITIAL) {
            currentCondition = currentCondition.and(Conditions.nest((Condition)nextCondition));
        } else if (combinator == CriteriaDefinition.Combinator.AND) {
            currentCondition = currentCondition.and(nextCondition);
        } else if (combinator == CriteriaDefinition.Combinator.OR) {
            currentCondition = currentCondition.or(nextCondition);
        } else {
            throw new IllegalStateException("Combinator " + combinator + " not supported");
        }
        return currentCondition;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Condition mapCondition(CriteriaDefinition criteria, MapSqlParameterSource parameterSource, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        SQLType sqlType;
        Object mappedValue;
        Field propertyField = this.createPropertyField(entity, criteria.getColumn(), this.mappingContext);
        if (propertyField.isEmbedded()) {
            return this.mapEmbeddedObjectCondition(criteria, parameterSource, table, (RelationalPersistentProperty)((MetadataBackedField)propertyField).getPath().getLeafProperty());
        }
        TypeInformation actualType = propertyField.getTypeHint().getRequiredActualType();
        Column column = table.column(propertyField.getMappedColumnName());
        CriteriaDefinition.Comparator comparator = criteria.getComparator();
        Object object = criteria.getValue();
        if (object instanceof JdbcValue) {
            JdbcValue settableValue = (JdbcValue)object;
            mappedValue = this.convertValue(comparator, settableValue.getValue(), propertyField.getTypeHint());
            sqlType = this.getTypeHint(mappedValue, actualType.getType(), settableValue);
            return this.createCondition(column, mappedValue, sqlType, parameterSource, comparator, criteria.isIgnoreCase());
        }
        object = criteria.getValue();
        if (object instanceof ValueFunction) {
            ValueFunction valueFunction = (ValueFunction)object;
            mappedValue = valueFunction.map(v -> this.convertValue(comparator, v, propertyField.getTypeHint()));
            sqlType = propertyField.getSqlType();
            return this.createCondition(column, mappedValue, sqlType, parameterSource, comparator, criteria.isIgnoreCase());
        }
        if (propertyField instanceof MetadataBackedField) {
            MetadataBackedField metadataBackedField = (MetadataBackedField)propertyField;
            if (!(metadataBackedField.property == null || criteria.getValue() != null && criteria.getValue().getClass().isArray())) {
                RelationalPersistentProperty property = metadataBackedField.property;
                JdbcValue jdbcValue = this.convertToJdbcValue(property, criteria.getValue());
                mappedValue = jdbcValue.getValue();
                sqlType = jdbcValue.getJdbcType() != null ? jdbcValue.getJdbcType() : propertyField.getSqlType();
                return this.createCondition(column, mappedValue, sqlType, parameterSource, comparator, criteria.isIgnoreCase());
            }
        }
        mappedValue = this.convertValue(comparator, criteria.getValue(), propertyField.getTypeHint());
        sqlType = propertyField.getSqlType();
        return this.createCondition(column, mappedValue, sqlType, parameterSource, comparator, criteria.isIgnoreCase());
    }

    private JdbcValue convertToJdbcValue(RelationalPersistentProperty property, @Nullable Object value) {
        if (value == null) {
            return JdbcValue.of(null, JDBCType.NULL);
        }
        if (value instanceof Pair) {
            JdbcValue first = this.getWriteValue(property, ((Pair)value).getFirst());
            JdbcValue second = this.getWriteValue(property, ((Pair)value).getSecond());
            return JdbcValue.of(Pair.of((Object)first.getValue(), (Object)second.getValue()), first.getJdbcType());
        }
        if (value instanceof Iterable) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            SQLType jdbcType = null;
            for (Object o : (Iterable)value) {
                JdbcValue jdbcValue = this.getWriteValue(property, o);
                if (jdbcType == null) {
                    jdbcType = jdbcValue.getJdbcType();
                }
                mapped.add(jdbcValue.getValue());
            }
            return JdbcValue.of(mapped, jdbcType);
        }
        if (value.getClass().isArray()) {
            Object[] valueAsArray = (Object[])value;
            Object[] mappedValueArray = new Object[valueAsArray.length];
            SQLType jdbcType = null;
            for (int i = 0; i < valueAsArray.length; ++i) {
                JdbcValue jdbcValue = this.getWriteValue(property, valueAsArray[i]);
                if (jdbcType == null) {
                    jdbcType = jdbcValue.getJdbcType();
                }
                mappedValueArray[i] = jdbcValue.getValue();
            }
            return JdbcValue.of(mappedValueArray, jdbcType);
        }
        return this.getWriteValue(property, value);
    }

    private JdbcValue getWriteValue(RelationalPersistentProperty property, Object value) {
        return this.converter.writeJdbcValue(value, this.converter.getColumnType(property), this.converter.getTargetSqlType(property));
    }

    private Condition mapEmbeddedObjectCondition(CriteriaDefinition criteria, MapSqlParameterSource parameterSource, Table table, RelationalPersistentProperty embeddedProperty) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)embeddedProperty);
        Assert.isInstanceOf((Class)persistentEntity.getType(), (Object)criteria.getValue(), () -> "Value must be of type " + persistentEntity.getType().getName() + " for embedded entity matching");
        PersistentPropertyAccessor embeddedAccessor = persistentEntity.getPropertyAccessor(criteria.getValue());
        Condition condition = null;
        for (RelationalPersistentProperty nestedProperty : persistentEntity) {
            SqlIdentifier sqlIdentifier = nestedProperty.getColumnName();
            Object mappedNestedValue = this.convertValue(embeddedAccessor.getProperty((PersistentProperty)nestedProperty), nestedProperty.getTypeInformation());
            SQLType sqlType = this.converter.getTargetSqlType(nestedProperty);
            Condition mappedCondition = this.createCondition(table.column(sqlIdentifier), mappedNestedValue, sqlType, parameterSource, criteria.getComparator(), criteria.isIgnoreCase());
            if (condition != null) {
                condition = condition.and(mappedCondition);
                continue;
            }
            condition = mappedCondition;
        }
        return Conditions.nest(condition);
    }

    @Nullable
    private Object convertValue(CriteriaDefinition.Comparator comparator, @Nullable Object value, TypeInformation<?> typeHint) {
        Collection collection;
        if ((CriteriaDefinition.Comparator.IN.equals((Object)comparator) || CriteriaDefinition.Comparator.NOT_IN.equals((Object)comparator)) && value instanceof Collection && !(collection = (Collection)value).isEmpty()) {
            ArrayList<Object> mapped = new ArrayList<Object>(collection.size());
            for (Object o : collection) {
                mapped.add(this.convertValue(o, typeHint));
            }
            return mapped;
        }
        return this.convertValue(value, typeHint);
    }

    @Nullable
    protected Object convertValue(@Nullable Object value, TypeInformation<?> typeInformation) {
        if (value == null) {
            return null;
        }
        if (value instanceof Pair) {
            Pair pair = (Pair)value;
            Object first = this.convertValue(pair.getFirst(), typeInformation.getActualType() != null ? typeInformation.getRequiredActualType() : TypeInformation.OBJECT);
            Object second = this.convertValue(pair.getSecond(), typeInformation.getActualType() != null ? typeInformation.getRequiredActualType() : TypeInformation.OBJECT);
            return Pair.of((Object)first, (Object)second);
        }
        if (value.getClass().isArray() && (TypeInformation.OBJECT.equals(typeInformation) || typeInformation.isCollectionLike())) {
            return value;
        }
        return this.converter.writeValue(value, typeInformation);
    }

    protected MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private Condition createCondition(Column column, @Nullable Object mappedValue, SQLType sqlType, MapSqlParameterSource parameterSource, CriteriaDefinition.Comparator comparator, boolean ignoreCase) {
        if (comparator.equals((Object)CriteriaDefinition.Comparator.IS_NULL)) {
            return column.isNull();
        }
        if (comparator.equals((Object)CriteriaDefinition.Comparator.IS_NOT_NULL)) {
            return column.isNotNull();
        }
        if (comparator == CriteriaDefinition.Comparator.IS_TRUE) {
            Expression bind = this.bindBoolean(column, parameterSource, mappedValue instanceof Boolean ? (Boolean)mappedValue : true);
            return column.isEqualTo(bind);
        }
        if (comparator == CriteriaDefinition.Comparator.IS_FALSE) {
            Expression bind = this.bindBoolean(column, parameterSource, mappedValue instanceof Boolean ? (Boolean)mappedValue : false);
            return column.isEqualTo(bind);
        }
        Column columnExpression = column;
        if (ignoreCase && (sqlType == JDBCType.VARCHAR || sqlType == JDBCType.NVARCHAR)) {
            columnExpression = Functions.upper((Expression)column);
        }
        if (comparator == CriteriaDefinition.Comparator.NOT_IN || comparator == CriteriaDefinition.Comparator.IN) {
            In condition;
            if (mappedValue instanceof Iterable) {
                ArrayList<Expression> expressions = new ArrayList<Expression>(mappedValue instanceof Collection ? ((Collection)mappedValue).size() : 10);
                for (Object o : (Iterable)mappedValue) {
                    expressions.add(this.bind(o, sqlType, parameterSource, column.getName().getReference()));
                }
                condition = Conditions.in((Expression)columnExpression, (Expression[])expressions.toArray(new Expression[0]));
            } else {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, column.getName().getReference());
                condition = Conditions.in((Expression)columnExpression, (Expression)expression);
            }
            if (comparator == CriteriaDefinition.Comparator.NOT_IN) {
                condition = condition.not();
            }
            return condition;
        }
        if (comparator == CriteriaDefinition.Comparator.BETWEEN || comparator == CriteriaDefinition.Comparator.NOT_BETWEEN) {
            Pair pair = (Pair)mappedValue;
            Expression begin = this.bind(pair.getFirst(), sqlType, parameterSource, column.getName().getReference(), ignoreCase);
            Expression end = this.bind(pair.getSecond(), sqlType, parameterSource, column.getName().getReference(), ignoreCase);
            return comparator == CriteriaDefinition.Comparator.BETWEEN ? Conditions.between((Expression)columnExpression, (Expression)begin, (Expression)end) : Conditions.notBetween((Expression)columnExpression, (Expression)begin, (Expression)end);
        }
        String refName = column.getName().getReference();
        switch (comparator) {
            case EQ: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName, ignoreCase);
                return Conditions.isEqual((Expression)columnExpression, (Expression)expression);
            }
            case NEQ: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName, ignoreCase);
                return Conditions.isEqual((Expression)columnExpression, (Expression)expression).not();
            }
            case LT: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName);
                return column.isLess(expression);
            }
            case LTE: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName);
                return column.isLessOrEqualTo(expression);
            }
            case GT: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName);
                return column.isGreater(expression);
            }
            case GTE: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName);
                return column.isGreaterOrEqualTo(expression);
            }
            case LIKE: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName, ignoreCase);
                return Conditions.like((Expression)columnExpression, (Expression)expression);
            }
            case NOT_LIKE: {
                Expression expression = this.bind(mappedValue, sqlType, parameterSource, refName, ignoreCase);
                return Conditions.notLike((Expression)columnExpression, (Expression)expression);
            }
        }
        throw new UnsupportedOperationException("Comparator " + comparator + " not supported");
    }

    private Expression bindBoolean(Column column, MapSqlParameterSource parameterSource, boolean value) {
        Object converted = this.converter.writeValue(value, TypeInformation.OBJECT);
        return this.bind(converted, JDBCType.BIT, parameterSource, column.getName().getReference());
    }

    Field createPropertyField(@Nullable RelationalPersistentEntity<?> entity, SqlIdentifier key) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, this.mappingContext, this.converter);
    }

    Field createPropertyField(@Nullable RelationalPersistentEntity<?> entity, SqlIdentifier key, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, mappingContext, this.converter);
    }

    SQLType getTypeHint(@Nullable Object mappedValue, Class<?> propertyType, JdbcValue settableValue) {
        if (mappedValue == null || propertyType.equals(Object.class)) {
            return JdbcUtil.TYPE_UNKNOWN;
        }
        if (mappedValue.getClass().equals(settableValue.getValue().getClass())) {
            return JdbcUtil.TYPE_UNKNOWN;
        }
        return settableValue.getJdbcType();
    }

    private Expression bind(@Nullable Object mappedValue, SQLType sqlType, MapSqlParameterSource parameterSource, String name) {
        return this.bind(mappedValue, sqlType, parameterSource, name, false);
    }

    private Expression bind(@Nullable Object mappedValue, SQLType sqlType, MapSqlParameterSource parameterSource, String name, boolean ignoreCase) {
        String uniqueName = QueryMapper.getUniqueName(parameterSource, name);
        parameterSource.addValue(uniqueName, mappedValue, sqlType.getVendorTypeNumber().intValue());
        return ignoreCase ? Functions.upper((Expression)SQL.bindMarker((String)(":" + uniqueName))) : SQL.bindMarker((String)(":" + uniqueName));
    }

    private static String getUniqueName(MapSqlParameterSource parameterSource, String name) {
        String uniqueName;
        Map values = parameterSource.getValues();
        if (!values.containsKey(name)) {
            return name;
        }
        int counter = 1;
        while (values.containsKey(uniqueName = name + counter++)) {
        }
        return uniqueName;
    }

    protected static class Field {
        protected final SqlIdentifier name;

        Field(SqlIdentifier name) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
        }

        public boolean isEmbedded() {
            return false;
        }

        public SqlIdentifier getMappedColumnName() {
            return this.name;
        }

        public TypeInformation<?> getTypeHint() {
            return TypeInformation.OBJECT;
        }

        public SQLType getSqlType() {
            return JdbcUtil.TYPE_UNKNOWN;
        }
    }

    protected static class MetadataBackedField
    extends Field {
        private final RelationalPersistentEntity<?> entity;
        private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        private final RelationalPersistentProperty property;
        @Nullable
        private final PersistentPropertyPath<RelationalPersistentProperty> path;
        private final boolean embedded;
        private final SQLType sqlType;

        protected MetadataBackedField(SqlIdentifier name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context, JdbcConverter converter) {
            this(name, entity, context, null, converter);
        }

        protected MetadataBackedField(SqlIdentifier name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context, @Nullable RelationalPersistentProperty property, JdbcConverter converter) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(name.getReference());
            this.property = this.path == null ? property : (RelationalPersistentProperty)this.path.getLeafProperty();
            this.sqlType = this.property != null ? converter.getTargetSqlType(this.property) : JdbcUtil.TYPE_UNKNOWN;
            this.embedded = this.property != null ? this.property.isEmbedded() : false;
        }

        @Override
        public SqlIdentifier getMappedColumnName() {
            if (this.isEmbedded()) {
                throw new IllegalStateException("Cannot obtain a single column name for embedded property");
            }
            return this.path == null || this.path.getLeafProperty() == null ? super.getMappedColumnName() : ((RelationalPersistentProperty)this.path.getLeafProperty()).getColumnName();
        }

        @Nullable
        private PersistentPropertyPath<RelationalPersistentProperty> getPath(String pathExpression) {
            try {
                PropertyPath path = PropertyPath.from((String)pathExpression, (TypeInformation)this.entity.getTypeInformation());
                if (this.isPathToJavaLangClassProperty(path)) {
                    return null;
                }
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (PropertyReferenceException | InvalidPersistentPropertyPath e) {
                return null;
            }
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return path.getType().equals(Class.class) && path.getLeafProperty().getOwningType().getType().equals(Class.class);
        }

        @Nullable
        public PersistentPropertyPath<RelationalPersistentProperty> getPath() {
            return this.path;
        }

        @Override
        public boolean isEmbedded() {
            return this.embedded;
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            if (this.property == null) {
                return super.getTypeHint();
            }
            if (this.property.getType().isPrimitive()) {
                return TypeInformation.of((Class)ClassUtils.resolvePrimitiveIfNecessary((Class)this.property.getType()));
            }
            if (this.property.getType().isArray()) {
                return this.property.getTypeInformation();
            }
            return this.property.getTypeInformation();
        }

        @Override
        public SQLType getSqlType() {
            return this.sqlType;
        }
    }
}

