/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.ObjectArrayColumns;
import org.springframework.data.relational.core.dialect.TimestampAtUtcToOffsetDateTimeConverter;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.util.ClassUtils;

public class PostgresDialect
extends AbstractDialect {
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final ObjectArrayColumns ARRAY_COLUMNS = ObjectArrayColumns.INSTANCE;
    private final PostgresLockClause LOCK_CLAUSE = new PostgresLockClause(this.getIdentifierProcessing());

    protected PostgresDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return this.LOCK_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return ARRAY_COLUMNS;
    }

    @Override
    public Collection<Object> getConverters() {
        return Collections.singletonList(TimestampAtUtcToOffsetDateTimeConverter.INSTANCE);
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.create(IdentifierProcessing.Quoting.ANSI, IdentifierProcessing.LetterCasing.LOWER_CASE);
    }

    @Override
    public Set<Class<?>> simpleTypes() {
        HashSet simpleTypes = new HashSet();
        List<String> simpleTypeNames = Arrays.asList("org.postgresql.util.PGobject", "org.postgresql.geometric.PGpoint", "org.postgresql.geometric.PGbox", "org.postgresql.geometric.PGcircle", "org.postgresql.geometric.PGline", "org.postgresql.geometric.PGpath", "org.postgresql.geometric.PGpolygon", "org.postgresql.geometric.PGlseg");
        simpleTypeNames.forEach(name -> PostgresDialect.ifClassPresent(name, simpleTypes::add));
        return Collections.unmodifiableSet(simpleTypes);
    }

    private static void ifClassPresent(String className, Consumer<Class<?>> action) {
        if (ClassUtils.isPresent((String)className, (ClassLoader)PostgresDialect.class.getClassLoader())) {
            action.accept(ClassUtils.resolveClassName((String)className, (ClassLoader)PostgresDialect.class.getClassLoader()));
        }
    }

    @Override
    public SimpleFunction getExistsFunction() {
        return Functions.least(Functions.count(SQL.literalOf(1)), SQL.literalOf(1));
    }

    static class PostgresLockClause
    implements LockClause {
        private final IdentifierProcessing identifierProcessing;

        PostgresLockClause(IdentifierProcessing identifierProcessing) {
            this.identifierProcessing = identifierProcessing;
        }

        @Override
        public String getLock(LockOptions lockOptions) {
            SqlIdentifier identifier;
            List<TableLike> tables = lockOptions.getFrom().getTables();
            if (tables.isEmpty()) {
                return "";
            }
            SqlIdentifier last = identifier = tables.get(0).getName();
            Iterator iterator = identifier.iterator();
            while (iterator.hasNext()) {
                SqlIdentifier sqlIdentifier;
                last = sqlIdentifier = (SqlIdentifier)iterator.next();
            }
            String tableName = last.toSql(this.identifierProcessing);
            switch (lockOptions.getLockMode()) {
                case PESSIMISTIC_WRITE: {
                    return "FOR UPDATE OF " + tableName;
                }
                case PESSIMISTIC_READ: {
                    return "FOR SHARE OF " + tableName;
                }
            }
            return "";
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    }
}

