/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLengthHeaderSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayRawSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArraySingleTerminatorSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayStxEtxSerializer;

public final class TcpCodecs {
    private static ByteArrayLengthHeaderSerializer oneByteLHS;
    private static ByteArrayLengthHeaderSerializer twoByteLHS;
    private static ByteArrayLengthHeaderSerializer fourByteLHS;

    private TcpCodecs() {
    }

    public static ByteArrayCrLfSerializer crlf() {
        return ByteArrayCrLfSerializer.INSTANCE;
    }

    public static ByteArrayLfSerializer lf() {
        return ByteArrayLfSerializer.INSTANCE;
    }

    public static ByteArrayRawSerializer raw() {
        return ByteArrayRawSerializer.INSTANCE;
    }

    public static ByteArrayStxEtxSerializer stxetx() {
        return ByteArrayStxEtxSerializer.INSTANCE;
    }

    public static ByteArraySingleTerminatorSerializer singleTerminator(byte terminator) {
        return new ByteArraySingleTerminatorSerializer(terminator);
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader1() {
        if (oneByteLHS == null) {
            oneByteLHS = new ByteArrayLengthHeaderSerializer(1);
        }
        return oneByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader2() {
        if (twoByteLHS == null) {
            twoByteLHS = new ByteArrayLengthHeaderSerializer(2);
        }
        return twoByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader4() {
        if (fourByteLHS == null) {
            fourByteLHS = new ByteArrayLengthHeaderSerializer(4);
        }
        return fourByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader(int bytes) {
        switch (bytes) {
            case 1: {
                return TcpCodecs.lengthHeader1();
            }
            case 2: {
                return TcpCodecs.lengthHeader2();
            }
            case 4: {
                return TcpCodecs.lengthHeader4();
            }
        }
        throw new IllegalArgumentException("Only 1, 2 or 4 byte headers are supported");
    }
}

