/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.util.StringUtils;

class MBeanExporterHelper
implements BeanFactoryPostProcessor,
BeanPostProcessor,
Ordered,
BeanFactoryAware {
    private static final String EXCLUDED_BEANS_PROPERTY_NAME = "excludedBeans";
    private static final String SI_ROOT_PACKAGE = "org.springframework.integration.";
    private final Set<String> siBeanNames = new HashSet<String>();
    private volatile BeanFactory beanFactory;
    private volatile boolean capturedAutoChannelCandidates;

    MBeanExporterHelper() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.capturedAutoChannelCandidates && this.beanFactory != null) {
            Object autoCreateChannelCandidates = this.beanFactory.getBean("$autoCreateChannelCandidates");
            if (autoCreateChannelCandidates != null) {
                Collection autoCreateChannelCandidatesNames = (Collection)new DirectFieldAccessor(autoCreateChannelCandidates).getPropertyValue("channelNames");
                this.siBeanNames.addAll(autoCreateChannelCandidatesNames);
            }
            this.capturedAutoChannelCandidates = true;
        }
        if (bean instanceof MBeanExporter && !(bean instanceof IntegrationMBeanExporter)) {
            MBeanExporter mbeanExporter = (MBeanExporter)bean;
            DirectFieldAccessor mbeDfa = new DirectFieldAccessor((Object)mbeanExporter);
            Set excludedNames = (Set)mbeDfa.getPropertyValue(EXCLUDED_BEANS_PROPERTY_NAME);
            if (excludedNames != null) {
                this.siBeanNames.addAll(excludedNames);
            }
            mbeDfa.setPropertyValue(EXCLUDED_BEANS_PROPERTY_NAME, this.siBeanNames);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanDefinitionNames;
        for (String beanName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            String className = bd.getBeanClassName();
            if (!StringUtils.hasText((String)className) || !className.startsWith(SI_ROOT_PACKAGE) || className.endsWith(IntegrationMBeanExporter.class.getName())) continue;
            this.siBeanNames.add(beanName);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

