/* Generated By:JavaCC: Do not edit this line. ValangParser.java */
/*
 * Copyright 2004-2005 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springmodules.validation.valang.parser;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.*;

import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springmodules.validation.util.date.DateParseException;
import org.springmodules.validation.util.date.DefaultDateParser;
import org.springmodules.validation.valang.functions.*;
import org.springmodules.validation.valang.predicates.BasicValidationRule;
import org.springmodules.validation.valang.predicates.Operator;
import org.springmodules.validation.valang.predicates.OperatorConstants;

public class ValangParser implements ValangParserConstants {

    private static Log log = LogFactory.getLog(ValangParser.class);

    private DefaultVisitor visitor = new DefaultVisitor();

    public ValangParser(String expression) {
        this(new StringReader(expression));
    }

    public ValangParser(String expression, Map customFunctions, Map dateParsers) {
        this(new StringReader(expression));
        setDateParsersByRegexp(dateParsers);
        setFunctionsByName(customFunctions);
    }

    public DefaultVisitor getVisitor() {
        if (this.visitor == null) {
            throw new IllegalStateException("Visistor is not set on parser");
        }
        return this.visitor;
    }

    public void setVisitor(DefaultVisitor visitor) {
        Assert.notNull(visitor, "ValangParser cannot accept a 'null' visitor");
        this.visitor = visitor;
    }

    public void setDateParsersByRegexp(Map dateParsersByRegexp) {
        if (dateParsersByRegexp == null) {
            return;
        }
        for (Iterator iter = dateParsersByRegexp.keySet().iterator(); iter.hasNext();) {
            String regexp = (String) iter.next();
            Object value = dateParsersByRegexp.get(regexp);

            if (value instanceof String) {
                getVisitor().getDateParser().register(regexp, (String) value);
            } else if (value instanceof DefaultDateParser.DateModifier) {
                getVisitor().getDateParser().register(regexp, (DefaultDateParser.DateModifier) value);
            } else {
                throw new ClassCastException("Could not register instance [" + value + "] with date parser!");
            }
        }
    }

    public void setFunctionsByName(Map functionsByName) {
        if (functionsByName == null) {
            return;
        }
        final Map constructorMap = new HashMap();
        for (Iterator iter = functionsByName.keySet().iterator(); iter.hasNext();) {
            Object stringNameObject = iter.next();
            if (!(stringNameObject instanceof String)) {
                throw new IllegalArgumentException("Key for custom functions map must be a string value!");
            }
            String functionName = (String) stringNameObject;

            Object functionClassNameObject = functionsByName.get(functionName);
            if (!(functionClassNameObject instanceof String)) {
                throw new IllegalArgumentException("Value for custom function map must be a string!");
            }
            String functionClassName = (String) functionClassNameObject;
            Class functionClass = loadClass(functionClassName);
            if (!(Function.class.isAssignableFrom(functionClass))) {
                throw new IllegalArgumentException("Custom function classes must implement org.springmodules.validation.valang.functions.Function!");
            }
            Constructor constructor = null;
            try {
                constructor = functionClass.getConstructor(new Class[]{Function[].class, int.class, int.class});
            } catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class [" + functionClass.getName() + "] has no constructor with one org.springmodules.validation.valang.functions.Function parameter!");
            }
            constructorMap.put(functionName, constructor);
        }
        getVisitor().setVisitor(new ValangVisitor() {
            public Function getFunction(String name, Function[] functions, int line, int column) {
                if (constructorMap.containsKey(name)) {
                    Constructor functionConstructor = (Constructor) constructorMap.get(name);
                    return (Function) BeanUtils.instantiateClass(functionConstructor, new Object[]{functions, new Integer(line), new Integer(column)});
                }
                return null;
            }
        });
    }

    private Class loadClass(String className) {
        try {
            return ClassUtils.forName(className);
        } catch (ClassNotFoundException cnfe) {
            log.error("Could not load class '" + className + "'", cnfe);
            throw new IllegalArgumentException("Could not load class '" + className + "'");
        }
    }

    private String replace(String s) {
        String tmpS = s;

        tmpS = StringUtils.replace(tmpS, "\\'", "'");
        tmpS = StringUtils.replace(tmpS, "\\n", "\n");
        tmpS = StringUtils.replace(tmpS, "\\r", "\r");
        tmpS = StringUtils.replace(tmpS, "\\t", "\t");
        tmpS = StringUtils.replace(tmpS, "\\b", "\b");
        tmpS = StringUtils.replace(tmpS, "\\f", "\f");
        tmpS = StringUtils.replace(tmpS, "\\\\", "\\");

        return tmpS;
    }

    final public Predicate parseExpression() throws ParseException {
        Predicate predicate = null;
        Function targetBeanFunction = new TargetBeanFunction();
        predicate = predicates(targetBeanFunction);
        jj_consume_token(0);
        {
            if (true) return predicate;
        }
        throw new Error("Missing return statement in function");
    }

    final public Collection parseValidation() throws ParseException {
        Predicate predicate = null;
        Collection rules = new ArrayList();
        String message = null;
        String field = null;
        String errorKey = null;
        Collection errorArgs = null;
        Function function = null;
        Function fieldFunction = null;
        label_1:
        while (true) {
            jj_consume_token(52);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case FUNCTION_NAME:
                    jj_consume_token(FUNCTION_NAME);
                    break;
                case PATH:
                    jj_consume_token(PATH);
                    break;
                default:
                    jj_la1[0] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            field = token.image;
            fieldFunction = new BeanPropertyFunction(field);
            /* MOD-26: re-initiliaze error key and arguments to null for every rule.
                      kudos to Cesar Ordinana for reporting this bug. */
            errorKey = null;
            errorArgs = new ArrayList();
            jj_consume_token(53);
            predicate = predicates(fieldFunction);
            jj_consume_token(53);
            jj_consume_token(STRING);
            message = token.image.substring(1, token.image.length() - 1);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case 53:
                    jj_consume_token(53);
                    jj_consume_token(STRING);
                    errorKey = token.image.substring(1, token.image.length() - 1);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case 53:
                            jj_consume_token(53);
                            label_2:
                            while (true) {
                                if (jj_2_1(2)) {
                                    ;
                                } else {
                                    break label_2;
                                }
                                function = function(fieldFunction);
                                errorArgs.add(function);
                                jj_consume_token(54);
                            }
                            function = function(fieldFunction);
                            errorArgs.add(function);
                            break;
                        default:
                            jj_la1[1] = jj_gen;
                            ;
                    }
                    break;
                default:
                    jj_la1[2] = jj_gen;
                    ;
            }
            jj_consume_token(55);
            /* take into account error key and error args for localization */
            rules.add(new BasicValidationRule(field, predicate, errorKey, message, errorArgs));
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case 52:
                    ;
                    break;
                default:
                    jj_la1[3] = jj_gen;
                    break label_1;
            }
        }
        jj_consume_token(0);
        {
            if (true) return rules;
        }
        throw new Error("Missing return statement in function");
    }

    final public Predicate not(Function fieldFunction) throws ParseException {
        Predicate predicate = null;
        jj_consume_token(NOT);
        predicate = expression(fieldFunction);
        {
            if (true) return NotPredicate.getInstance(predicate);
        }
        throw new Error("Missing return statement in function");
    }

    final public Predicate predicates(Function fieldFunction) throws ParseException {
        Predicate predicate1 = null;
        Predicate predicate2 = null;
        boolean andTest = false;
        boolean orTest = false;
        predicate1 = expression(fieldFunction);
        label_3:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case AND:
                case OR:
                    ;
                    break;
                default:
                    jj_la1[4] = jj_gen;
                    break label_3;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case AND:
                    jj_consume_token(AND);
                    andTest = true;
                    break;
                case OR:
                    jj_consume_token(OR);
                    orTest = true;
                    break;
                default:
                    jj_la1[5] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            predicate2 = expression(fieldFunction);
            if (andTest) {
                predicate1 = AndPredicate.getInstance(predicate1, predicate2);
                andTest = false;
            } else if (orTest) {
                predicate1 = OrPredicate.getInstance(predicate1, predicate2);
                orTest = false;
            }
        }
        {
            if (true) return predicate1;
        }
        throw new Error("Missing return statement in function");
    }

    final public Predicate expression(Function fieldFunction) throws ParseException {
        Predicate predicate = null;
        if (jj_2_2(2147483647)) {
            jj_consume_token(56);
            predicate = predicates(fieldFunction);
            jj_consume_token(57);
        } else {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NOT:
                    predicate = not(fieldFunction);
                    break;
                case TRUE:
                case FALSE:
                case NUM:
                case STRING:
                case DATE:
                case FUNCTION_NAME:
                case PATH:
                case 56:
                case 59:
                case 60:
                    predicate = predicate(fieldFunction);
                    break;
                default:
                    jj_la1[6] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        {
            if (true) return predicate;
        }
        throw new Error("Missing return statement in function");
    }

    final public Predicate predicate(Function fieldFunction) throws ParseException {
        Function leftFunction = null;
        Function rightFunction1 = null;
        Function rightFunction2 = null;
        Function tmpFunction = null;
        Operator operator = null;
        boolean notBetween = false;
        boolean notIn = false;
        Collection functions = new ArrayList();
        boolean collectionProperty = false;
        leftFunction = additiveExpr(fieldFunction);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case IS_NULL:
            case IS_NOT_NULL:
            case HAS_TEXT:
            case HAS_NO_TEXT:
            case HAS_LENGTH:
            case HAS_NO_LENGTH:
            case IS_BLANK:
            case IS_NOT_BLANK:
            case IS_UPPER_CASE:
            case IS_NOT_UPPER_CASE:
            case IS_LOWER_CASE:
            case IS_NOT_LOWER_CASE:
            case IS_WORD:
            case IS_NOT_WORD:
            case MORE_THAN_OR_EQUAL:
            case MORE_THAN:
            case LESS_THAN_OR_EQUAL:
            case LESS_THAN:
            case NOT_EQUAL:
            case EQUALS:
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case MORE_THAN_OR_EQUAL:
                    case MORE_THAN:
                    case LESS_THAN_OR_EQUAL:
                    case LESS_THAN:
                    case NOT_EQUAL:
                    case EQUALS:
                        operator = binaryOperator();
                        rightFunction1 = additiveExpr(fieldFunction);
                        break;
                    case IS_NULL:
                    case IS_NOT_NULL:
                    case HAS_TEXT:
                    case HAS_NO_TEXT:
                    case HAS_LENGTH:
                    case HAS_NO_LENGTH:
                    case IS_BLANK:
                    case IS_NOT_BLANK:
                    case IS_UPPER_CASE:
                    case IS_NOT_UPPER_CASE:
                    case IS_LOWER_CASE:
                    case IS_NOT_LOWER_CASE:
                    case IS_WORD:
                    case IS_NOT_WORD:
                        operator = unaryOperator();
                        break;
                    default:
                        jj_la1[7] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
            {
                if (true) return getVisitor().getPredicate(leftFunction, operator, rightFunction1, 0, 0);
            }
            break;
            case BETWEEN:
            case NOT_BETWEEN:
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case BETWEEN:
                        jj_consume_token(BETWEEN);
                        break;
                    case NOT_BETWEEN:
                        jj_consume_token(NOT_BETWEEN);
                        notBetween = true;
                        break;
                    default:
                        jj_la1[8] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                rightFunction1 = additiveExpr(fieldFunction);
                jj_consume_token(AND);
                rightFunction2 = additiveExpr(fieldFunction);
                if (notBetween) {
                    {
                        if (true)
                            return getVisitor().getPredicate(leftFunction, OperatorConstants.NOT_BETWEEN_OPERATOR, new LiteralFunction(new Function[]{rightFunction1, rightFunction2}), 0, 0);
                    }
                } else {
                    {
                        if (true)
                            return getVisitor().getPredicate(leftFunction, OperatorConstants.BETWEEN_OPERATOR, new LiteralFunction(new Function[]{rightFunction1, rightFunction2}), 0, 0);
                    }
                }
                break;
            case IN:
            case NOT_IN:
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case IN:
                        jj_consume_token(IN);
                        break;
                    case NOT_IN:
                        jj_consume_token(NOT_IN);
                        notIn = true;
                        break;
                    default:
                        jj_la1[9] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case TRUE:
                    case FALSE:
                    case NUM:
                    case STRING:
                    case DATE:
                    case FUNCTION_NAME:
                    case PATH:
                    case 56:
                    case 59:
                    case 60:
                        label_4:
                        while (true) {
                            if (jj_2_3(2)) {
                                ;
                            } else {
                                break label_4;
                            }
                            tmpFunction = additiveExpr(fieldFunction);
                            functions.add(tmpFunction);
                            jj_consume_token(54);
                        }
                        tmpFunction = additiveExpr(fieldFunction);
                        functions.add(tmpFunction);
                        break;
                    case 58:
                        jj_consume_token(58);
                        tmpFunction = beanProperty(fieldFunction);
                        collectionProperty = true;
                        break;
                    default:
                        jj_la1[10] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                if (!collectionProperty) {
                    tmpFunction = new LiteralFunction(functions);
                }
                if (notIn) {
                    {
                        if (true)
                            return getVisitor().getPredicate(leftFunction, OperatorConstants.NOT_IN_OPERATOR, tmpFunction, 0, 0);
                    }
                } else {
                    {
                        if (true)
                            return getVisitor().getPredicate(leftFunction, OperatorConstants.IN_OPERATOR, tmpFunction, 0, 0);
                    }
                }
                break;
            default:
                jj_la1[11] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public Function function(Function fieldFunction) throws ParseException {
        String function = null;
        Function leftFunction = null;
        Function rightFunction = null;
        int line = 0;
        int column = 0;
        Collection functionArguments = new ArrayList();
        if (jj_2_4(2)) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case 59:
                    jj_consume_token(59);
                    break;
                case FUNCTION_NAME:
                    jj_consume_token(FUNCTION_NAME);
                    break;
                default:
                    jj_la1[12] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            function = token.image;
            line = token.beginLine;
            column = token.beginColumn;
            jj_consume_token(56);
            leftFunction = function(fieldFunction);
            functionArguments.add(leftFunction);
            label_5:
            while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 54:
                        ;
                        break;
                    default:
                        jj_la1[13] = jj_gen;
                        break label_5;
                }
                jj_consume_token(54);
                leftFunction = function(fieldFunction);
                functionArguments.add(leftFunction);
            }
            jj_consume_token(57);
            leftFunction = getVisitor().getFunction(function, (Function[]) functionArguments.toArray(new Function[functionArguments.size()]), line, column);
        } else {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case TRUE:
                case FALSE:
                case NUM:
                case STRING:
                case DATE:
                case FUNCTION_NAME:
                case PATH:
                    leftFunction = beanPropertyOrLiteral(fieldFunction);
                    break;
                case 60:
                    jj_consume_token(60);
                    leftFunction = fieldFunction;
                    break;
                case 56:
                    jj_consume_token(56);
                    leftFunction = additiveExpr(fieldFunction);
                    jj_consume_token(57);
                    break;
                default:
                    jj_la1[14] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        {
            if (true) return leftFunction;
        }
        throw new Error("Missing return statement in function");
    }

    final public Function additiveExpr(Function fieldFunction) throws ParseException {
        Function leftFunction = null;
        Function rightFunction = null;
        int line = 0;
        int column = 0;
        leftFunction = subtractiveExpr(fieldFunction);
        label_6:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case ADD:
                    ;
                    break;
                default:
                    jj_la1[15] = jj_gen;
                    break label_6;
            }
            jj_consume_token(ADD);
            line = token.beginLine;
            column = token.beginColumn;
            rightFunction = subtractiveExpr(fieldFunction);
            leftFunction = new AddFunction(leftFunction, rightFunction, line, column);
        }
        {
            if (true) return leftFunction;
        }
        throw new Error("Missing return statement in function");
    }

    final public Function subtractiveExpr(Function fieldFunction) throws ParseException {
        Function leftFunction = null;
        Function rightFunction = null;
        int line = 0;
        int column = 0;
        leftFunction = multiplicativeExpr(fieldFunction);
        label_7:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SUBTRACT:
                    ;
                    break;
                default:
                    jj_la1[16] = jj_gen;
                    break label_7;
            }
            jj_consume_token(SUBTRACT);
            line = token.beginLine;
            column = token.beginColumn;
            rightFunction = multiplicativeExpr(fieldFunction);
            leftFunction = new SubtractFunction(leftFunction, rightFunction, line, column);
        }
        {
            if (true) return leftFunction;
        }
        throw new Error("Missing return statement in function");
    }

    final public Function multiplicativeExpr(Function fieldFunction) throws ParseException {
        Function leftFunction = null;
        Function rightFunction = null;
        int line = 0;
        int column = 0;
        leftFunction = function(fieldFunction);
        label_8:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case MULTIPLY:
                case DIVIDE:
                case MOD:
                    ;
                    break;
                default:
                    jj_la1[17] = jj_gen;
                    break label_8;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case MULTIPLY:
                    jj_consume_token(MULTIPLY);
                    line = token.beginLine;
                    column = token.beginColumn;
                    rightFunction = function(fieldFunction);
                    leftFunction = new MultiplyFunction(leftFunction, rightFunction, line, column);
                    break;
                case DIVIDE:
                    jj_consume_token(DIVIDE);
                    line = token.beginLine;
                    column = token.beginColumn;
                    rightFunction = function(fieldFunction);
                    leftFunction = new DivideFunction(leftFunction, rightFunction, line, column);
                    break;
                case MOD:
                    jj_consume_token(MOD);
                    line = token.beginLine;
                    column = token.beginColumn;
                    rightFunction = function(fieldFunction);
                    leftFunction = new ModuloFunction(leftFunction, rightFunction, line, column);
                    break;
                default:
                    jj_la1[18] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        {
            if (true) return leftFunction;
        }
        throw new Error("Missing return statement in function");
    }

    final public Function beanPropertyOrLiteral(Function fieldFunction) throws ParseException {
        Function function = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case TRUE:
            case FALSE:
            case NUM:
            case STRING:
            case DATE:
                function = literal();
            {
                if (true) return function;
            }
            break;
            case FUNCTION_NAME:
            case PATH:
                function = beanProperty(fieldFunction);
            {
                if (true) return function;
            }
            break;
            default:
                jj_la1[19] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public Function literal() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case TRUE:
                jj_consume_token(TRUE);
            {
                if (true) return new LiteralFunction(Boolean.TRUE);
            }
            break;
            case FALSE:
                jj_consume_token(FALSE);
            {
                if (true) return new LiteralFunction(Boolean.FALSE);
            }
            break;
            case STRING:
                jj_consume_token(STRING);
            {
                if (true) return new LiteralFunction(replace(token.image.substring(1, token.image.length() - 1)));
            }
            break;
            case NUM:
                jj_consume_token(NUM);
            {
                if (true) return new LiteralFunction(new BigDecimal(token.image));
            }
            break;
            case DATE:
                jj_consume_token(DATE);
                try {
                    getVisitor().getDateParser().parse(token.image.substring(1, token.image.length() - 1));
                } catch (DateParseException e) {
                    {
                        if (true)
                            throw new ParseException("Could not parse date [" + token.image.substring(1, token.image.length() - 1) + "] at line " + token.beginLine + ", column " + token.beginColumn + ".");
                    }
                }
            {
                if (true)
                    return new DateLiteralFunction(token.image.substring(1, token.image.length() - 1), getVisitor().getDateParser(), token.beginLine, token.beginColumn);
            }
            break;
            default:
                jj_la1[20] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public Function beanProperty(Function fieldFunction) throws ParseException {
        Function function = null;
        function = path();
        {
            if (true) return function;
        }
        throw new Error("Missing return statement in function");
    }

    final public Function path() throws ParseException {
        String path = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case PATH:
                jj_consume_token(PATH);
                path = token.image;
                break;
            case FUNCTION_NAME:
                jj_consume_token(FUNCTION_NAME);
                path = token.image;
                break;
            default:
                jj_la1[21] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return new BeanPropertyFunction(path);
        }
        throw new Error("Missing return statement in function");
    }

    final public Operator binaryOperator() throws ParseException {
        Operator operator = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NOT_EQUAL:
                jj_consume_token(NOT_EQUAL);
                operator = OperatorConstants.NOT_EQUAL_OPERATOR;
                break;
            case MORE_THAN_OR_EQUAL:
                jj_consume_token(MORE_THAN_OR_EQUAL);
                operator = OperatorConstants.MORE_THAN_OR_EQUAL_OPERATOR;
                break;
            case MORE_THAN:
                jj_consume_token(MORE_THAN);
                operator = OperatorConstants.MORE_THAN_OPERATOR;
                break;
            case LESS_THAN_OR_EQUAL:
                jj_consume_token(LESS_THAN_OR_EQUAL);
                operator = OperatorConstants.LESS_THAN_OR_EQUAL_OPERATOR;
                break;
            case LESS_THAN:
                jj_consume_token(LESS_THAN);
                operator = OperatorConstants.LESS_THAN_OPERATOR;
                break;
            case EQUALS:
                jj_consume_token(EQUALS);
                operator = OperatorConstants.EQUALS_OPERATOR;
                break;
            default:
                jj_la1[22] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return operator;
        }
        throw new Error("Missing return statement in function");
    }

    final public Operator unaryOperator() throws ParseException {
        Operator operator = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case IS_NULL:
                jj_consume_token(IS_NULL);
                operator = OperatorConstants.NULL_OPERATOR;
                break;
            case IS_NOT_NULL:
                jj_consume_token(IS_NOT_NULL);
                operator = OperatorConstants.NOT_NULL_OPERATOR;
                break;
            case HAS_TEXT:
                jj_consume_token(HAS_TEXT);
                operator = OperatorConstants.HAS_TEXT_OPERATOR;
                break;
            case HAS_NO_TEXT:
                jj_consume_token(HAS_NO_TEXT);
                operator = OperatorConstants.HAS_NO_TEXT_OPERATOR;
                break;
            case HAS_LENGTH:
                jj_consume_token(HAS_LENGTH);
                operator = OperatorConstants.HAS_LENGTH_OPERATOR;
                break;
            case HAS_NO_LENGTH:
                jj_consume_token(HAS_NO_LENGTH);
                operator = OperatorConstants.HAS_NO_LENGTH_OPERATOR;
                break;
            case IS_BLANK:
                jj_consume_token(IS_BLANK);
                operator = OperatorConstants.IS_BLANK_OPERATOR;
                break;
            case IS_NOT_BLANK:
                jj_consume_token(IS_NOT_BLANK);
                operator = OperatorConstants.IS_NOT_BLANK_OPERATOR;
                break;
            case IS_WORD:
                jj_consume_token(IS_WORD);
                operator = OperatorConstants.IS_WORD_OPERATOR;
                break;
            case IS_NOT_WORD:
                jj_consume_token(IS_NOT_WORD);
                operator = OperatorConstants.IS_NOT_WORD_OPERATOR;
                break;
            case IS_UPPER_CASE:
                jj_consume_token(IS_UPPER_CASE);
                operator = OperatorConstants.IS_UPPER_CASE_OPERATOR;
                break;
            case IS_NOT_UPPER_CASE:
                jj_consume_token(IS_NOT_UPPER_CASE);
                operator = OperatorConstants.IS_NOT_UPPER_CASE_OPERATOR;
                break;
            case IS_LOWER_CASE:
                jj_consume_token(IS_LOWER_CASE);
                operator = OperatorConstants.IS_LOWER_CASE_OPERATOR;
                break;
            case IS_NOT_LOWER_CASE:
                jj_consume_token(IS_NOT_LOWER_CASE);
                operator = OperatorConstants.IS_NOT_LOWER_CASE_OPERATOR;
                break;
            default:
                jj_la1[23] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return operator;
        }
        throw new Error("Missing return statement in function");
    }

    final private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    final private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    final private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    final private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    final private boolean jj_3R_52() {
        if (jj_scan_token(PATH)) return true;
        return false;
    }

    final private boolean jj_3_2() {
        if (jj_scan_token(56)) return true;
        if (jj_3R_10()) return true;
        if (jj_scan_token(57)) return true;
        return false;
    }

    final private boolean jj_3R_22() {
        if (jj_3R_30()) return true;
        return false;
    }

    final private boolean jj_3R_45() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_52()) {
            jj_scanpos = xsp;
            if (jj_3R_53()) return true;
        }
        return false;
    }

    final private boolean jj_3R_21() {
        if (jj_3R_29()) return true;
        return false;
    }

    final private boolean jj_3R_20() {
        if (jj_scan_token(56)) return true;
        if (jj_3R_10()) return true;
        if (jj_scan_token(57)) return true;
        return false;
    }

    final private boolean jj_3R_33() {
        if (jj_3R_45()) return true;
        return false;
    }

    final private boolean jj_3R_24() {
        if (jj_scan_token(OR)) return true;
        return false;
    }

    final private boolean jj_3R_15() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_20()) {
            jj_scanpos = xsp;
            if (jj_3R_21()) {
                jj_scanpos = xsp;
                if (jj_3R_22()) return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_23() {
        if (jj_scan_token(AND)) return true;
        return false;
    }

    final private boolean jj_3R_16() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_23()) {
            jj_scanpos = xsp;
            if (jj_3R_24()) return true;
        }
        if (jj_3R_15()) return true;
        return false;
    }

    final private boolean jj_3R_44() {
        if (jj_scan_token(DATE)) return true;
        return false;
    }

    final private boolean jj_3R_43() {
        if (jj_scan_token(NUM)) return true;
        return false;
    }

    final private boolean jj_3R_42() {
        if (jj_scan_token(STRING)) return true;
        return false;
    }

    final private boolean jj_3R_41() {
        if (jj_scan_token(FALSE)) return true;
        return false;
    }

    final private boolean jj_3R_40() {
        if (jj_scan_token(TRUE)) return true;
        return false;
    }

    final private boolean jj_3R_27() {
        if (jj_3R_32()) return true;
        return false;
    }

    final private boolean jj_3R_32() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_40()) {
            jj_scanpos = xsp;
            if (jj_3R_41()) {
                jj_scanpos = xsp;
                if (jj_3R_42()) {
                    jj_scanpos = xsp;
                    if (jj_3R_43()) {
                        jj_scanpos = xsp;
                        if (jj_3R_44()) return true;
                    }
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_28() {
        if (jj_3R_33()) return true;
        return false;
    }

    final private boolean jj_3_1() {
        if (jj_3R_9()) return true;
        if (jj_scan_token(54)) return true;
        return false;
    }

    final private boolean jj_3R_10() {
        if (jj_3R_15()) return true;
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_16()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_39() {
        if (jj_scan_token(MOD)) return true;
        if (jj_3R_9()) return true;
        return false;
    }

    final private boolean jj_3R_19() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_27()) {
            jj_scanpos = xsp;
            if (jj_3R_28()) return true;
        }
        return false;
    }

    final private boolean jj_3R_38() {
        if (jj_scan_token(DIVIDE)) return true;
        if (jj_3R_9()) return true;
        return false;
    }

    final private boolean jj_3R_37() {
        if (jj_scan_token(MULTIPLY)) return true;
        if (jj_3R_9()) return true;
        return false;
    }

    final private boolean jj_3R_31() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_37()) {
            jj_scanpos = xsp;
            if (jj_3R_38()) {
                jj_scanpos = xsp;
                if (jj_3R_39()) return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_29() {
        if (jj_scan_token(NOT)) return true;
        if (jj_3R_15()) return true;
        return false;
    }

    final private boolean jj_3R_25() {
        if (jj_3R_9()) return true;
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_31()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_26() {
        if (jj_scan_token(SUBTRACT)) return true;
        if (jj_3R_25()) return true;
        return false;
    }

    final private boolean jj_3R_17() {
        if (jj_3R_25()) return true;
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_26()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_18() {
        if (jj_scan_token(ADD)) return true;
        if (jj_3R_17()) return true;
        return false;
    }

    final private boolean jj_3R_11() {
        if (jj_3R_17()) return true;
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_18()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_76() {
        if (jj_scan_token(54)) return true;
        if (jj_3R_9()) return true;
        return false;
    }

    final private boolean jj_3R_14() {
        if (jj_scan_token(56)) return true;
        if (jj_3R_11()) return true;
        if (jj_scan_token(57)) return true;
        return false;
    }

    final private boolean jj_3R_13() {
        if (jj_scan_token(60)) return true;
        return false;
    }

    final private boolean jj_3R_12() {
        if (jj_3R_19()) return true;
        return false;
    }

    final private boolean jj_3R_51() {
        if (jj_scan_token(58)) return true;
        if (jj_3R_33()) return true;
        return false;
    }

    final private boolean jj_3_3() {
        if (jj_3R_11()) return true;
        if (jj_scan_token(54)) return true;
        return false;
    }

    final private boolean jj_3_4() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(59)) {
            jj_scanpos = xsp;
            if (jj_scan_token(50)) return true;
        }
        if (jj_scan_token(56)) return true;
        if (jj_3R_9()) return true;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_76()) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_scan_token(57)) return true;
        return false;
    }

    final private boolean jj_3R_50() {
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_3()) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_3R_11()) return true;
        return false;
    }

    final private boolean jj_3R_49() {
        if (jj_scan_token(NOT_IN)) return true;
        return false;
    }

    final private boolean jj_3R_9() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_4()) {
            jj_scanpos = xsp;
            if (jj_3R_12()) {
                jj_scanpos = xsp;
                if (jj_3R_13()) {
                    jj_scanpos = xsp;
                    if (jj_3R_14()) return true;
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_48() {
        if (jj_scan_token(NOT_BETWEEN)) return true;
        return false;
    }

    final private boolean jj_3R_75() {
        if (jj_scan_token(IS_NOT_LOWER_CASE)) return true;
        return false;
    }

    final private boolean jj_3R_74() {
        if (jj_scan_token(IS_LOWER_CASE)) return true;
        return false;
    }

    final private boolean jj_3R_73() {
        if (jj_scan_token(IS_NOT_UPPER_CASE)) return true;
        return false;
    }

    final private boolean jj_3R_72() {
        if (jj_scan_token(IS_UPPER_CASE)) return true;
        return false;
    }

    final private boolean jj_3R_71() {
        if (jj_scan_token(IS_NOT_WORD)) return true;
        return false;
    }

    final private boolean jj_3R_70() {
        if (jj_scan_token(IS_WORD)) return true;
        return false;
    }

    final private boolean jj_3R_69() {
        if (jj_scan_token(IS_NOT_BLANK)) return true;
        return false;
    }

    final private boolean jj_3R_68() {
        if (jj_scan_token(IS_BLANK)) return true;
        return false;
    }

    final private boolean jj_3R_36() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(10)) {
            jj_scanpos = xsp;
            if (jj_3R_49()) return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_50()) {
            jj_scanpos = xsp;
            if (jj_3R_51()) return true;
        }
        return false;
    }

    final private boolean jj_3R_67() {
        if (jj_scan_token(HAS_NO_LENGTH)) return true;
        return false;
    }

    final private boolean jj_3R_66() {
        if (jj_scan_token(HAS_LENGTH)) return true;
        return false;
    }

    final private boolean jj_3R_65() {
        if (jj_scan_token(HAS_NO_TEXT)) return true;
        return false;
    }

    final private boolean jj_3R_64() {
        if (jj_scan_token(HAS_TEXT)) return true;
        return false;
    }

    final private boolean jj_3R_47() {
        if (jj_3R_55()) return true;
        return false;
    }

    final private boolean jj_3R_63() {
        if (jj_scan_token(IS_NOT_NULL)) return true;
        return false;
    }

    final private boolean jj_3R_62() {
        if (jj_scan_token(IS_NULL)) return true;
        return false;
    }

    final private boolean jj_3R_46() {
        if (jj_3R_54()) return true;
        if (jj_3R_11()) return true;
        return false;
    }

    final private boolean jj_3R_34() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_46()) {
            jj_scanpos = xsp;
            if (jj_3R_47()) return true;
        }
        return false;
    }

    final private boolean jj_3R_55() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_62()) {
            jj_scanpos = xsp;
            if (jj_3R_63()) {
                jj_scanpos = xsp;
                if (jj_3R_64()) {
                    jj_scanpos = xsp;
                    if (jj_3R_65()) {
                        jj_scanpos = xsp;
                        if (jj_3R_66()) {
                            jj_scanpos = xsp;
                            if (jj_3R_67()) {
                                jj_scanpos = xsp;
                                if (jj_3R_68()) {
                                    jj_scanpos = xsp;
                                    if (jj_3R_69()) {
                                        jj_scanpos = xsp;
                                        if (jj_3R_70()) {
                                            jj_scanpos = xsp;
                                            if (jj_3R_71()) {
                                                jj_scanpos = xsp;
                                                if (jj_3R_72()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3R_73()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3R_74()) {
                                                            jj_scanpos = xsp;
                                                            if (jj_3R_75()) return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_35() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(8)) {
            jj_scanpos = xsp;
            if (jj_3R_48()) return true;
        }
        if (jj_3R_11()) return true;
        if (jj_scan_token(AND)) return true;
        if (jj_3R_11()) return true;
        return false;
    }

    final private boolean jj_3R_61() {
        if (jj_scan_token(EQUALS)) return true;
        return false;
    }

    final private boolean jj_3R_60() {
        if (jj_scan_token(LESS_THAN)) return true;
        return false;
    }

    final private boolean jj_3R_59() {
        if (jj_scan_token(LESS_THAN_OR_EQUAL)) return true;
        return false;
    }

    final private boolean jj_3R_58() {
        if (jj_scan_token(MORE_THAN)) return true;
        return false;
    }

    final private boolean jj_3R_57() {
        if (jj_scan_token(MORE_THAN_OR_EQUAL)) return true;
        return false;
    }

    final private boolean jj_3R_56() {
        if (jj_scan_token(NOT_EQUAL)) return true;
        return false;
    }

    final private boolean jj_3R_54() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_56()) {
            jj_scanpos = xsp;
            if (jj_3R_57()) {
                jj_scanpos = xsp;
                if (jj_3R_58()) {
                    jj_scanpos = xsp;
                    if (jj_3R_59()) {
                        jj_scanpos = xsp;
                        if (jj_3R_60()) {
                            jj_scanpos = xsp;
                            if (jj_3R_61()) return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_30() {
        if (jj_3R_11()) return true;
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_34()) {
            jj_scanpos = xsp;
            if (jj_3R_35()) {
                jj_scanpos = xsp;
                if (jj_3R_36()) return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_53() {
        if (jj_scan_token(FUNCTION_NAME)) return true;
        return false;
    }

    public ValangParserTokenManager token_source;

    JavaCharStream jj_input_stream;

    public Token token, jj_nt;

    private int jj_ntk;

    private Token jj_scanpos, jj_lastpos;

    private int jj_la;

    public boolean lookingAhead = false;

    private boolean jj_semLA;

    private int jj_gen;

    final private int[] jj_la1 = new int[24];

    static private int[] jj_la1_0;

    static private int[] jj_la1_1;

    static {
        jj_la1_0();
        jj_la1_1();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x0, 0x0, 0x0, 0x0, 0x60, 0x60, 0xc000080, 0xf3fff000, 0x300, 0xc00, 0xc000000, 0xf3ffff00, 0x0, 0x0, 0xc000000, 0x0, 0x0, 0x0, 0x0, 0xc000000, 0xc000000, 0x0, 0xf0000000, 0x3fff000,};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0xc0000, 0x200000, 0x200000, 0x100000, 0x0, 0x0, 0x190c0380, 0x3, 0x0, 0x0, 0x1d0c0380, 0x3, 0x8040000, 0x400000, 0x110c0380, 0x4, 0x8, 0x70, 0x70, 0xc0380, 0x380, 0xc0000, 0x3, 0x0,};
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[4];

    private boolean jj_rescan = false;

    private int jj_gc = 0;

    public ValangParser(java.io.InputStream stream) {
        this(stream, null);
    }

    public ValangParser(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new ValangParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public ValangParser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ValangParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public ValangParser(ValangParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(ValangParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 24; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    final private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) token = token.next;
        else token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) c.first = null;
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    static private final class LookaheadSuccess extends java.lang.Error {

    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    final private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) jj_add_error_token(kind, i);
        }
        if (jj_scanpos.kind != kind) return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
        return false;
    }

    final public Token getNextToken() {
        if (token.next != null) token = token.next;
        else token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    final public Token getToken(int index) {
        Token t = lookingAhead ? jj_scanpos : token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) t = t.next;
            else t = t.next = token_source.getNextToken();
        }
        return t;
    }

    final private int jj_ntk() {
        if ((jj_nt = token.next) == null) return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        else return (jj_ntk = jj_nt.kind);
    }

    private java.util.Vector jj_expentries = new java.util.Vector();

    private int[] jj_expentry;

    private int jj_kind = -1;

    private int[] jj_lasttokens = new int[100];

    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) return;
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            boolean exists = false;
            for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
                int[] oldentry = (int[]) (e.nextElement());
                if (oldentry.length == jj_expentry.length) {
                    exists = true;
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            exists = false;
                            break;
                        }
                    }
                    if (exists) break;
                }
            }
            if (!exists) jj_expentries.addElement(jj_expentry);
            if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
        }
    }

    public ParseException generateParseException() {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[61];
        for (int i = 0; i < 61; i++) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 24; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 61; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = (int[]) jj_expentries.elementAt(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    final public void enable_tracing() {
    }

    final public void disable_tracing() {
    }

    final private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 4; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {
            }
        }
        jj_rescan = false;
    }

    final private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {

        int gen;

        Token first;

        int arg;

        JJCalls next;
    }

}
