/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputMediaAudio
extends InputMedia {
    private static final String TYPE = "audio";
    public static final String DURATION_FIELD = "duration";
    public static final String PERFORMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="performer")
    private String performer;
    @JsonProperty(value="title")
    private String title;
    private InputFile thumbnail;

    public InputMediaAudio() {
    }

    public InputMediaAudio(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaAudio(@NonNull String media, String caption, String parseMode, List<MessageEntity> entities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Integer duration, String performer, String title, InputFile thumbnail) {
        super(media, caption, parseMode, entities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.duration = duration;
        this.performer = performer;
        this.title = title;
        this.thumbnail = thumbnail;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    @JsonIgnore
    @Deprecated
    public InputFile getThumb() {
        return this.thumbnail;
    }

    @JsonIgnore
    @Deprecated
    public void setThumb(InputFile thumb) {
        this.thumbnail = thumb;
    }

    public static InputMediaAudioBuilder builder() {
        return new InputMediaAudioBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaAudio)) {
            return false;
        }
        InputMediaAudio other = (InputMediaAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$performer = this.getPerformer();
        String other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaAudio;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="performer")
    public void setPerformer(String performer) {
        this.performer = performer;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public String toString() {
        return "InputMediaAudio(duration=" + this.getDuration() + ", performer=" + this.getPerformer() + ", title=" + this.getTitle() + ", thumbnail=" + this.getThumbnail() + ")";
    }

    public static class InputMediaAudioBuilder {
        private String media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> entities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;
        private Integer duration;
        private String performer;
        private String title;
        private InputFile thumbnail;

        @Deprecated
        public InputMediaAudioBuilder thumb(InputFile thumb) {
            this.thumbnail = thumb;
            return this;
        }

        InputMediaAudioBuilder() {
        }

        public InputMediaAudioBuilder media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public InputMediaAudioBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InputMediaAudioBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InputMediaAudioBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputMediaAudioBuilder isNewMedia(boolean isNewMedia) {
            this.isNewMedia = isNewMedia;
            return this;
        }

        public InputMediaAudioBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public InputMediaAudioBuilder newMediaFile(File newMediaFile) {
            this.newMediaFile = newMediaFile;
            return this;
        }

        public InputMediaAudioBuilder newMediaStream(InputStream newMediaStream) {
            this.newMediaStream = newMediaStream;
            return this;
        }

        public InputMediaAudioBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public InputMediaAudioBuilder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public InputMediaAudioBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InputMediaAudioBuilder thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public InputMediaAudio build() {
            return new InputMediaAudio(this.media, this.caption, this.parseMode, this.entities, this.isNewMedia, this.mediaName, this.newMediaFile, this.newMediaStream, this.duration, this.performer, this.title, this.thumbnail);
        }

        public String toString() {
            return "InputMediaAudio.InputMediaAudioBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ", duration=" + this.duration + ", performer=" + this.performer + ", title=" + this.title + ", thumbnail=" + this.thumbnail + ")";
        }
    }
}

