/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.facilities;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.proxysocketfactorys.HttpConnectionSocketFactory;
import org.telegram.telegrambots.facilities.proxysocketfactorys.HttpSSLConnectionSocketFactory;
import org.telegram.telegrambots.facilities.proxysocketfactorys.SocksConnectionSocketFactory;
import org.telegram.telegrambots.facilities.proxysocketfactorys.SocksSSLConnectionSocketFactory;

public class TelegramHttpClientBuilder {
    public static CloseableHttpClient build(DefaultBotOptions options) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setConnectionManager(TelegramHttpClientBuilder.createConnectionManager(options)).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100);
        return httpClientBuilder.build();
    }

    private static HttpClientConnectionManager createConnectionManager(DefaultBotOptions options) {
        switch (options.getProxyType()) {
            case NO_PROXY: {
                return null;
            }
            case HTTP: {
                Registry registry = RegistryBuilder.create().register("http", (Object)new HttpConnectionSocketFactory()).register("https", (Object)new HttpSSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
                return new PoolingHttpClientConnectionManager(registry);
            }
            case SOCKS4: 
            case SOCKS5: {
                Registry registry = RegistryBuilder.create().register("http", (Object)new SocksConnectionSocketFactory()).register("https", (Object)new SocksSSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
                return new PoolingHttpClientConnectionManager(registry);
            }
        }
        return null;
    }
}

