/*
 * Decompiled with CFR 0.152.
 */
package ru.yaal.maven.writetextfiles;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import ru.yaal.maven.writetextfiles.FileParameter;

class PropertyReplacer {
    private static final Pattern pattern = Pattern.compile("(\\$\\{([\\w\\.]*)\\})");
    private final String defaultNullValue;
    private final Boolean nullValueException;
    private final MavenProject project;

    public PropertyReplacer(MavenProject project, String defaultNullValue, Boolean nullValueException) {
        this.defaultNullValue = defaultNullValue;
        this.nullValueException = nullValueException;
        this.project = project;
    }

    public void replace(FileParameter file) throws Exception {
        String[] lines = file.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String s = lines[i];
            Matcher matcher = pattern.matcher(s);
            while (matcher.find()) {
                Object replaced;
                String withBraces = matcher.group(1);
                String withoutBraces = matcher.group(2);
                if (withoutBraces.startsWith("project.")) {
                    withoutBraces = withoutBraces.replaceFirst("project.", "");
                }
                if ((replaced = ReflectionValueExtractor.evaluate((String)withoutBraces, (Object)this.project)) != null) {
                    s = s.replace(withBraces, replaced.toString());
                    continue;
                }
                if (!this.nullValueException.booleanValue()) {
                    String value = file.getNullValue() != null ? file.getNullValue() : this.defaultNullValue;
                    s = s.replace(withBraces, value);
                    continue;
                }
                throw new MojoExecutionException("Value of property was not found: " + withBraces);
            }
            lines[i] = s;
        }
    }
}

