/*
 * Decompiled with CFR 0.152.
 */
package ru.yaal.maven.writetextfiles;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import ru.yaal.maven.writetextfiles.FileParameter;
import ru.yaal.maven.writetextfiles.PropertyReplacer;

@Mojo(name="write-text-files", requiresProject=true)
public class WriteTextFilesMojo
extends AbstractMojo {
    public static final String MOJO_NAME = "write-text-files";
    @Parameter(required=true)
    private FileParameter[] files;
    @Parameter(defaultValue="")
    private String nullValue;
    @Parameter(defaultValue="false")
    private Boolean nullValueException;
    @Parameter(defaultValue="UTF-8")
    private String charset;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            PropertyReplacer replacer = new PropertyReplacer(this.project, this.nullValue, this.nullValueException);
            for (FileParameter file : this.files) {
                replacer.replace(file);
                File path = file.getPath();
                if (path == null) {
                    throw new MojoExecutionException("Path is empty");
                }
                path.getParentFile().mkdirs();
                if (!path.createNewFile()) {
                    this.getLog().warn((CharSequence)("Overwrite file: " + path.getAbsolutePath()));
                } else {
                    this.getLog().info((CharSequence)("Write to new file: " + path.getAbsolutePath()));
                }
                Files.write(path.toPath(), Arrays.asList(file.getLines()), Charset.forName(this.charset), new OpenOption[0]);
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

