/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed <code>InternetConfiguration</code> or <code>VpcConfiguration</code> to apply to the Amazon S3 access
 * point. <code>VpcConfiguration</code> does not apply to multi-region access points. You can make the access point
 * accessible from the internet, or you can specify that all requests made through that access point must originate from
 * a specific virtual private cloud (VPC). You can specify only one type of network configuration. For more information,
 * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkOriginConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkOriginConfiguration.Builder, NetworkOriginConfiguration> {
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(NetworkOriginConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<InternetConfiguration> INTERNET_CONFIGURATION_FIELD = SdkField
            .<InternetConfiguration> builder(MarshallingType.SDK_POJO).memberName("internetConfiguration")
            .getter(getter(NetworkOriginConfiguration::internetConfiguration)).setter(setter(Builder::internetConfiguration))
            .constructor(InternetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internetConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGURATION_FIELD,
            INTERNET_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final VpcConfiguration vpcConfiguration;

    private final InternetConfiguration internetConfiguration;

    private final Type type;

    private NetworkOriginConfiguration(BuilderImpl builder) {
        this.vpcConfiguration = builder.vpcConfiguration;
        this.internetConfiguration = builder.internetConfiguration;
        this.type = builder.type;
    }

    /**
     * Returns the value of the VpcConfiguration property for this object.
     * 
     * @return The value of the VpcConfiguration property for this object.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code>
     * origin.
     * </p>
     * 
     * @return The configuration for the Amazon S3 access point or multi-region access point with an
     *         <code>Internet</code> origin.
     */
    public final InternetConfiguration internetConfiguration() {
        return internetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(internetConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkOriginConfiguration)) {
            return false;
        }
        NetworkOriginConfiguration other = (NetworkOriginConfiguration) obj;
        return Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(internetConfiguration(), other.internetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkOriginConfiguration").add("VpcConfiguration", vpcConfiguration())
                .add("InternetConfiguration", internetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "internetConfiguration":
            return Optional.ofNullable(clazz.cast(internetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #vpcConfiguration()} initialized to the given value.
     *
     * Sets the value of the VpcConfiguration property for this object.
     *
     * @param vpcConfiguration
     *        The new value for the VpcConfiguration property for this object.
     */
    public static NetworkOriginConfiguration fromVpcConfiguration(VpcConfiguration vpcConfiguration) {
        return builder().vpcConfiguration(vpcConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #vpcConfiguration()} initialized to the given value.
     *
     * Sets the value of the VpcConfiguration property for this object.
     *
     * @param vpcConfiguration
     *        The new value for the VpcConfiguration property for this object.
     */
    public static NetworkOriginConfiguration fromVpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
        VpcConfiguration.Builder builder = VpcConfiguration.builder();
        vpcConfiguration.accept(builder);
        return fromVpcConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #internetConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code>
     * origin.
     * </p>
     * 
     * @param internetConfiguration
     *        The configuration for the Amazon S3 access point or multi-region access point with an
     *        <code>Internet</code> origin.
     */
    public static NetworkOriginConfiguration fromInternetConfiguration(InternetConfiguration internetConfiguration) {
        return builder().internetConfiguration(internetConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #internetConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code>
     * origin.
     * </p>
     * 
     * @param internetConfiguration
     *        The configuration for the Amazon S3 access point or multi-region access point with an
     *        <code>Internet</code> origin.
     */
    public static NetworkOriginConfiguration fromInternetConfiguration(
            Consumer<InternetConfiguration.Builder> internetConfiguration) {
        InternetConfiguration.Builder builder = InternetConfiguration.builder();
        internetConfiguration.accept(builder);
        return fromInternetConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkOriginConfiguration, T> g) {
        return obj -> g.apply((NetworkOriginConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkOriginConfiguration> {
        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * @param vpcConfiguration
         *        The new value for the VpcConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code>
         * origin.
         * </p>
         * 
         * @param internetConfiguration
         *        The configuration for the Amazon S3 access point or multi-region access point with an
         *        <code>Internet</code> origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetConfiguration(InternetConfiguration internetConfiguration);

        /**
         * <p>
         * The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code>
         * origin.
         * </p>
         * This is a convenience method that creates an instance of the {@link InternetConfiguration.Builder} avoiding
         * the need to create one manually via {@link InternetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InternetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #internetConfiguration(InternetConfiguration)}.
         * 
         * @param internetConfiguration
         *        a consumer that will call methods on {@link InternetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetConfiguration(InternetConfiguration)
         */
        default Builder internetConfiguration(Consumer<InternetConfiguration.Builder> internetConfiguration) {
            return internetConfiguration(InternetConfiguration.builder().applyMutation(internetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpcConfiguration vpcConfiguration;

        private InternetConfiguration internetConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkOriginConfiguration model) {
            vpcConfiguration(model.vpcConfiguration);
            internetConfiguration(model.internetConfiguration);
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            Object oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
            handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            Object oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration;
            handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
            return this;
        }

        public final InternetConfiguration.Builder getInternetConfiguration() {
            return internetConfiguration != null ? internetConfiguration.toBuilder() : null;
        }

        public final void setInternetConfiguration(InternetConfiguration.BuilderImpl internetConfiguration) {
            Object oldValue = this.internetConfiguration;
            this.internetConfiguration = internetConfiguration != null ? internetConfiguration.build() : null;
            handleUnionValueChange(Type.INTERNET_CONFIGURATION, oldValue, this.internetConfiguration);
        }

        @Override
        public final Builder internetConfiguration(InternetConfiguration internetConfiguration) {
            Object oldValue = this.internetConfiguration;
            this.internetConfiguration = internetConfiguration;
            handleUnionValueChange(Type.INTERNET_CONFIGURATION, oldValue, this.internetConfiguration);
            return this;
        }

        @Override
        public NetworkOriginConfiguration build() {
            return new NetworkOriginConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NetworkOriginConfiguration#type()
     */
    public enum Type {
        VPC_CONFIGURATION,

        INTERNET_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
