/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values for a manual Amazon RDS DB cluster snapshot attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsDbClusterSnapshotAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsDbClusterSnapshotAttributeValue.Builder, RdsDbClusterSnapshotAttributeValue> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(RdsDbClusterSnapshotAttributeValue::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final Type type;

    private RdsDbClusterSnapshotAttributeValue(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the value
     * <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
     * <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses the
     * existing shared <code>accountIds</code> for the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the access preview is for a new resource and you do not specify the specify the <code>accountIds</code> in
     * <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview considers the snapshot without any
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
     * <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the
     *         value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied
     *         or restored by all Amazon Web Services accounts.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
     *         <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses
     *         the existing shared <code>accountIds</code> for the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the access preview is for a new resource and you do not specify the specify the
     *         <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview
     *         considers the snapshot without any attributes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
     *         <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
     *         </p>
     *         </li>
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbClusterSnapshotAttributeValue)) {
            return false;
        }
        RdsDbClusterSnapshotAttributeValue other = (RdsDbClusterSnapshotAttributeValue) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsDbClusterSnapshotAttributeValue").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accountIds()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the value
     * <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
     * <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses the
     * existing shared <code>accountIds</code> for the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the access preview is for a new resource and you do not specify the specify the <code>accountIds</code> in
     * <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview considers the snapshot without any
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
     * <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param accountIds
     *        The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the
     *        value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied
     *        or restored by all Amazon Web Services accounts.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
     *        <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses
     *        the existing shared <code>accountIds</code> for the snapshot.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the access preview is for a new resource and you do not specify the specify the <code>accountIds</code>
     *        in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview considers the snapshot without
     *        any attributes.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
     *        <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
     *        </p>
     *        </li>
     */
    public static RdsDbClusterSnapshotAttributeValue fromAccountIds(List<String> accountIds) {
        return builder().accountIds(accountIds).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsDbClusterSnapshotAttributeValue, T> g) {
        return obj -> g.apply((RdsDbClusterSnapshotAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsDbClusterSnapshotAttributeValue> {
        /**
         * <p>
         * The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the
         * value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied or
         * restored by all Amazon Web Services accounts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
         * <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses the
         * existing shared <code>accountIds</code> for the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the access preview is for a new resource and you do not specify the specify the <code>accountIds</code> in
         * <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview considers the snapshot without any
         * attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
         * <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param accountIds
         *        The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If
         *        the value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be
         *        copied or restored by all Amazon Web Services accounts.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
         *        <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview
         *        uses the existing shared <code>accountIds</code> for the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the access preview is for a new resource and you do not specify the specify the
         *        <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview
         *        considers the snapshot without any attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
         *        <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If the
         * value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be copied or
         * restored by all Amazon Web Services accounts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
         * <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview uses the
         * existing shared <code>accountIds</code> for the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the access preview is for a new resource and you do not specify the specify the <code>accountIds</code> in
         * <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview considers the snapshot without any
         * attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
         * <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param accountIds
         *        The Amazon Web Services account IDs that have access to the manual Amazon RDS DB cluster snapshot. If
         *        the value <code>all</code> is specified, then the Amazon RDS DB cluster snapshot is public and can be
         *        copied or restored by all Amazon Web Services accounts.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the configuration is for an existing Amazon RDS DB cluster snapshot and you do not specify the
         *        <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview
         *        uses the existing shared <code>accountIds</code> for the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the access preview is for a new resource and you do not specify the specify the
         *        <code>accountIds</code> in <code>RdsDbClusterSnapshotAttributeValue</code>, then the access preview
         *        considers the snapshot without any attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To propose deletion of existing shared <code>accountIds</code>, you can specify an empty list for
         *        <code>accountIds</code> in the <code>RdsDbClusterSnapshotAttributeValue</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbClusterSnapshotAttributeValue model) {
            accountIds(model.accountIds);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            Object oldValue = this.accountIds;
            this.accountIds = RdsDbClusterSnapshotAccountIdsListCopier.copy(accountIds);
            handleUnionValueChange(Type.ACCOUNT_IDS, oldValue, this.accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            Object oldValue = this.accountIds;
            this.accountIds = RdsDbClusterSnapshotAccountIdsListCopier.copy(accountIds);
            handleUnionValueChange(Type.ACCOUNT_IDS, oldValue, this.accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        public RdsDbClusterSnapshotAttributeValue build() {
            return new RdsDbClusterSnapshotAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RdsDbClusterSnapshotAttributeValue#type()
     */
    public enum Type {
        ACCOUNT_IDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
