/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidatePolicyResourceType {
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_S3_ACCESS_POINT("AWS::S3::AccessPoint"),
    AWS_S3_MULTI_REGION_ACCESS_POINT("AWS::S3::MultiRegionAccessPoint"),
    AWS_S3_OBJECT_LAMBDA_ACCESS_POINT("AWS::S3ObjectLambda::AccessPoint"),
    AWS_IAM_ASSUME_ROLE_POLICY_DOCUMENT("AWS::IAM::AssumeRolePolicyDocument"),
    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidatePolicyResourceType> VALUE_MAP;
    private final String value;

    private ValidatePolicyResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidatePolicyResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidatePolicyResourceType> knownValues() {
        EnumSet<ValidatePolicyResourceType> knownValues = EnumSet.allOf(ValidatePolicyResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidatePolicyResourceType.class, ValidatePolicyResourceType::toString);
    }
}

