/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.RegionOptStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Region
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Region> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(Region.getter(Region::regionName)).setter(Region.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REGION_OPT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionOptStatus").getter(Region.getter(Region::regionOptStatusAsString)).setter(Region.setter(Builder::regionOptStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOptStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REGION_OPT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Region.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String regionOptStatus;

    private Region(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.regionOptStatus = builder.regionOptStatus;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final RegionOptStatus regionOptStatus() {
        return RegionOptStatus.fromValue(this.regionOptStatus);
    }

    public final String regionOptStatusAsString() {
        return this.regionOptStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionOptStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.regionOptStatusAsString(), other.regionOptStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Region").add("RegionName", (Object)this.regionName()).add("RegionOptStatus", (Object)this.regionOptStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "RegionOptStatus": {
                return Optional.ofNullable(clazz.cast(this.regionOptStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("RegionOptStatus", REGION_OPT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String regionOptStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            this.regionName(model.regionName);
            this.regionOptStatus(model.regionOptStatus);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getRegionOptStatus() {
            return this.regionOptStatus;
        }

        public final void setRegionOptStatus(String regionOptStatus) {
            this.regionOptStatus = regionOptStatus;
        }

        @Override
        public final Builder regionOptStatus(String regionOptStatus) {
            this.regionOptStatus = regionOptStatus;
            return this;
        }

        @Override
        public final Builder regionOptStatus(RegionOptStatus regionOptStatus) {
            this.regionOptStatus(regionOptStatus == null ? null : regionOptStatus.toString());
            return this;
        }

        public Region build() {
            return new Region(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Region> {
        public Builder regionName(String var1);

        public Builder regionOptStatus(String var1);

        public Builder regionOptStatus(RegionOptStatus var1);
    }
}

