/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClientBuilder;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessServiceClientConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.DefaultAlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.DefaultAlexaForBusinessBaseClientBuilder;
import software.amazon.awssdk.services.alexaforbusiness.endpoints.AlexaForBusinessEndpointProvider;

@SdkInternalApi
final class DefaultAlexaForBusinessAsyncClientBuilder
extends DefaultAlexaForBusinessBaseClientBuilder<AlexaForBusinessAsyncClientBuilder, AlexaForBusinessAsyncClient>
implements AlexaForBusinessAsyncClientBuilder {
    DefaultAlexaForBusinessAsyncClientBuilder() {
    }

    @Override
    public DefaultAlexaForBusinessAsyncClientBuilder endpointProvider(AlexaForBusinessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AlexaForBusinessAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAlexaForBusinessAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AlexaForBusinessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAlexaForBusinessAsyncClient client = new DefaultAlexaForBusinessAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AlexaForBusinessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AlexaForBusinessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

