/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceNetworkProfileInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceNetworkProfileInfo> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkProfileArn").getter(DeviceNetworkProfileInfo.getter(DeviceNetworkProfileInfo::networkProfileArn)).setter(DeviceNetworkProfileInfo.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(DeviceNetworkProfileInfo.getter(DeviceNetworkProfileInfo::certificateArn)).setter(DeviceNetworkProfileInfo.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<Instant> CERTIFICATE_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CertificateExpirationTime").getter(DeviceNetworkProfileInfo.getter(DeviceNetworkProfileInfo::certificateExpirationTime)).setter(DeviceNetworkProfileInfo.setter(Builder::certificateExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_EXPIRATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkProfileArn;
    private final String certificateArn;
    private final Instant certificateExpirationTime;

    private DeviceNetworkProfileInfo(BuilderImpl builder) {
        this.networkProfileArn = builder.networkProfileArn;
        this.certificateArn = builder.certificateArn;
        this.certificateExpirationTime = builder.certificateExpirationTime;
    }

    public final String networkProfileArn() {
        return this.networkProfileArn;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final Instant certificateExpirationTime() {
        return this.certificateExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceNetworkProfileInfo)) {
            return false;
        }
        DeviceNetworkProfileInfo other = (DeviceNetworkProfileInfo)obj;
        return Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateExpirationTime(), other.certificateExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceNetworkProfileInfo").add("NetworkProfileArn", (Object)this.networkProfileArn()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateExpirationTime", (Object)this.certificateExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "CertificateExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.certificateExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceNetworkProfileInfo, T> g) {
        return obj -> g.apply((DeviceNetworkProfileInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkProfileArn;
        private String certificateArn;
        private Instant certificateExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceNetworkProfileInfo model) {
            this.networkProfileArn(model.networkProfileArn);
            this.certificateArn(model.certificateArn);
            this.certificateExpirationTime(model.certificateExpirationTime);
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final Instant getCertificateExpirationTime() {
            return this.certificateExpirationTime;
        }

        public final void setCertificateExpirationTime(Instant certificateExpirationTime) {
            this.certificateExpirationTime = certificateExpirationTime;
        }

        @Override
        public final Builder certificateExpirationTime(Instant certificateExpirationTime) {
            this.certificateExpirationTime = certificateExpirationTime;
            return this;
        }

        public DeviceNetworkProfileInfo build() {
            return new DeviceNetworkProfileInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceNetworkProfileInfo> {
        public Builder networkProfileArn(String var1);

        public Builder certificateArn(String var1);

        public Builder certificateExpirationTime(Instant var1);
    }
}

