/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WakeWord {
    ALEXA("ALEXA"),
    AMAZON("AMAZON"),
    ECHO("ECHO"),
    COMPUTER("COMPUTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WakeWord> VALUE_MAP;
    private final String value;

    private WakeWord(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WakeWord fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WakeWord> knownValues() {
        EnumSet<WakeWord> knownValues = EnumSet.allOf(WakeWord.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WakeWord.class, WakeWord::toString);
    }
}

