/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse;
import software.amazon.awssdk.services.amp.model.RuleGroupsNamespaceSummary;

public class ListRuleGroupsNamespacesIterable
implements SdkIterable<ListRuleGroupsNamespacesResponse> {
    private final AmpClient client;
    private final ListRuleGroupsNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRuleGroupsNamespacesIterable(AmpClient client, ListRuleGroupsNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRuleGroupsNamespacesResponseFetcher();
    }

    public Iterator<ListRuleGroupsNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleGroupsNamespaceSummary> ruleGroupsNamespaces() {
        Function<ListRuleGroupsNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleGroupsNamespaces() != null) {
                return response.ruleGroupsNamespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRuleGroupsNamespacesResponseFetcher
    implements SyncPageFetcher<ListRuleGroupsNamespacesResponse> {
        private ListRuleGroupsNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleGroupsNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRuleGroupsNamespacesResponse nextPage(ListRuleGroupsNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListRuleGroupsNamespacesIterable.this.client.listRuleGroupsNamespaces(ListRuleGroupsNamespacesIterable.this.firstRequest);
            }
            return ListRuleGroupsNamespacesIterable.this.client.listRuleGroupsNamespaces((ListRuleGroupsNamespacesRequest)((Object)ListRuleGroupsNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

