/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IgnoreNearExpected
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IgnoreNearExpected> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("amount").getter(IgnoreNearExpected.getter(IgnoreNearExpected::amount)).setter(IgnoreNearExpected.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<Double> RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ratio").getter(IgnoreNearExpected.getter(IgnoreNearExpected::ratio)).setter(IgnoreNearExpected.setter(Builder::ratio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratio").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, RATIO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IgnoreNearExpected.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double amount;
    private final Double ratio;
    private final Type type;

    private IgnoreNearExpected(BuilderImpl builder) {
        this.amount = builder.amount;
        this.ratio = builder.ratio;
        this.type = builder.type;
    }

    public final Double amount() {
        return this.amount;
    }

    public final Double ratio() {
        return this.ratio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ratio());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IgnoreNearExpected)) {
            return false;
        }
        IgnoreNearExpected other = (IgnoreNearExpected)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.ratio(), other.ratio());
    }

    public final String toString() {
        return ToString.builder((String)"IgnoreNearExpected").add("Amount", (Object)this.amount()).add("Ratio", (Object)this.ratio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "ratio": {
                return Optional.ofNullable(clazz.cast(this.ratio()));
            }
        }
        return Optional.empty();
    }

    public static IgnoreNearExpected fromAmount(Double amount) {
        return (IgnoreNearExpected)IgnoreNearExpected.builder().amount(amount).build();
    }

    public static IgnoreNearExpected fromRatio(Double ratio) {
        return (IgnoreNearExpected)IgnoreNearExpected.builder().ratio(ratio).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("amount", AMOUNT_FIELD);
        map.put("ratio", RATIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IgnoreNearExpected, T> g) {
        return obj -> g.apply((IgnoreNearExpected)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AMOUNT,
        RATIO,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private Double ratio;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IgnoreNearExpected model) {
            this.amount(model.amount);
            this.ratio(model.ratio);
        }

        public final Double getAmount() {
            return this.amount;
        }

        public final void setAmount(Double amount) {
            Double oldValue = this.amount;
            this.amount = amount;
            this.handleUnionValueChange(Type.AMOUNT, oldValue, this.amount);
        }

        @Override
        public final Builder amount(Double amount) {
            Double oldValue = this.amount;
            this.amount = amount;
            this.handleUnionValueChange(Type.AMOUNT, oldValue, this.amount);
            return this;
        }

        public final Double getRatio() {
            return this.ratio;
        }

        public final void setRatio(Double ratio) {
            Double oldValue = this.ratio;
            this.ratio = ratio;
            this.handleUnionValueChange(Type.RATIO, oldValue, this.ratio);
        }

        @Override
        public final Builder ratio(Double ratio) {
            Double oldValue = this.ratio;
            this.ratio = ratio;
            this.handleUnionValueChange(Type.RATIO, oldValue, this.ratio);
            return this;
        }

        public IgnoreNearExpected build() {
            return new IgnoreNearExpected(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IgnoreNearExpected> {
        public Builder amount(Double var1);

        public Builder ratio(Double var1);
    }
}

