/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleConfiguration> {
    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRoleArn").getter(RoleConfiguration.getter(RoleConfiguration::sourceRoleArn)).setter(RoleConfiguration.setter(Builder::sourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()}).build();
    private static final SdkField<String> TARGET_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRoleArn").getter(RoleConfiguration.getter(RoleConfiguration::targetRoleArn)).setter(RoleConfiguration.setter(Builder::targetRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ROLE_ARN_FIELD, TARGET_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoleConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceRoleArn;
    private final String targetRoleArn;

    private RoleConfiguration(BuilderImpl builder) {
        this.sourceRoleArn = builder.sourceRoleArn;
        this.targetRoleArn = builder.targetRoleArn;
    }

    public final String sourceRoleArn() {
        return this.sourceRoleArn;
    }

    public final String targetRoleArn() {
        return this.targetRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleConfiguration)) {
            return false;
        }
        RoleConfiguration other = (RoleConfiguration)obj;
        return Objects.equals(this.sourceRoleArn(), other.sourceRoleArn()) && Objects.equals(this.targetRoleArn(), other.targetRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"RoleConfiguration").add("SourceRoleArn", (Object)this.sourceRoleArn()).add("TargetRoleArn", (Object)this.targetRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sourceRoleArn()));
            }
            case "targetRoleArn": {
                return Optional.ofNullable(clazz.cast(this.targetRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourceRoleArn", SOURCE_ROLE_ARN_FIELD);
        map.put("targetRoleArn", TARGET_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoleConfiguration, T> g) {
        return obj -> g.apply((RoleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceRoleArn;
        private String targetRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleConfiguration model) {
            this.sourceRoleArn(model.sourceRoleArn);
            this.targetRoleArn(model.targetRoleArn);
        }

        public final String getSourceRoleArn() {
            return this.sourceRoleArn;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        @Override
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        public final String getTargetRoleArn() {
            return this.targetRoleArn;
        }

        public final void setTargetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
        }

        @Override
        public final Builder targetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
            return this;
        }

        public RoleConfiguration build() {
            return new RoleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleConfiguration> {
        public Builder sourceRoleArn(String var1);

        public Builder targetRoleArn(String var1);
    }
}

