/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AuthResources;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthIdentityPoolConfig;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig;
import software.amazon.awssdk.services.amplifybackend.model.Service;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendAuthResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBackendAuthResourceConfig> {
    private static final SdkField<String> AUTH_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthResources").getter(CreateBackendAuthResourceConfig.getter(CreateBackendAuthResourceConfig::authResourcesAsString)).setter(CreateBackendAuthResourceConfig.setter(Builder::authResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authResources").build()}).build();
    private static final SdkField<CreateBackendAuthIdentityPoolConfig> IDENTITY_POOL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityPoolConfigs").getter(CreateBackendAuthResourceConfig.getter(CreateBackendAuthResourceConfig::identityPoolConfigs)).setter(CreateBackendAuthResourceConfig.setter(Builder::identityPoolConfigs)).constructor(CreateBackendAuthIdentityPoolConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityPoolConfigs").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(CreateBackendAuthResourceConfig.getter(CreateBackendAuthResourceConfig::serviceAsString)).setter(CreateBackendAuthResourceConfig.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<CreateBackendAuthUserPoolConfig> USER_POOL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserPoolConfigs").getter(CreateBackendAuthResourceConfig.getter(CreateBackendAuthResourceConfig::userPoolConfigs)).setter(CreateBackendAuthResourceConfig.setter(Builder::userPoolConfigs)).constructor(CreateBackendAuthUserPoolConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfigs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_RESOURCES_FIELD, IDENTITY_POOL_CONFIGS_FIELD, SERVICE_FIELD, USER_POOL_CONFIGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authResources;
    private final CreateBackendAuthIdentityPoolConfig identityPoolConfigs;
    private final String service;
    private final CreateBackendAuthUserPoolConfig userPoolConfigs;

    private CreateBackendAuthResourceConfig(BuilderImpl builder) {
        this.authResources = builder.authResources;
        this.identityPoolConfigs = builder.identityPoolConfigs;
        this.service = builder.service;
        this.userPoolConfigs = builder.userPoolConfigs;
    }

    public final AuthResources authResources() {
        return AuthResources.fromValue(this.authResources);
    }

    public final String authResourcesAsString() {
        return this.authResources;
    }

    public final CreateBackendAuthIdentityPoolConfig identityPoolConfigs() {
        return this.identityPoolConfigs;
    }

    public final Service service() {
        return Service.fromValue(this.service);
    }

    public final String serviceAsString() {
        return this.service;
    }

    public final CreateBackendAuthUserPoolConfig userPoolConfigs() {
        return this.userPoolConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authResourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfigs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthResourceConfig)) {
            return false;
        }
        CreateBackendAuthResourceConfig other = (CreateBackendAuthResourceConfig)obj;
        return Objects.equals(this.authResourcesAsString(), other.authResourcesAsString()) && Objects.equals(this.identityPoolConfigs(), other.identityPoolConfigs()) && Objects.equals(this.serviceAsString(), other.serviceAsString()) && Objects.equals(this.userPoolConfigs(), other.userPoolConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendAuthResourceConfig").add("AuthResources", (Object)this.authResourcesAsString()).add("IdentityPoolConfigs", (Object)this.identityPoolConfigs()).add("Service", (Object)this.serviceAsString()).add("UserPoolConfigs", (Object)this.userPoolConfigs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthResources": {
                return Optional.ofNullable(clazz.cast(this.authResourcesAsString()));
            }
            case "IdentityPoolConfigs": {
                return Optional.ofNullable(clazz.cast(this.identityPoolConfigs()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
            case "UserPoolConfigs": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthResourceConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authResources;
        private CreateBackendAuthIdentityPoolConfig identityPoolConfigs;
        private String service;
        private CreateBackendAuthUserPoolConfig userPoolConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthResourceConfig model) {
            this.authResources(model.authResources);
            this.identityPoolConfigs(model.identityPoolConfigs);
            this.service(model.service);
            this.userPoolConfigs(model.userPoolConfigs);
        }

        public final String getAuthResources() {
            return this.authResources;
        }

        public final void setAuthResources(String authResources) {
            this.authResources = authResources;
        }

        @Override
        public final Builder authResources(String authResources) {
            this.authResources = authResources;
            return this;
        }

        @Override
        public final Builder authResources(AuthResources authResources) {
            this.authResources(authResources == null ? null : authResources.toString());
            return this;
        }

        public final CreateBackendAuthIdentityPoolConfig.Builder getIdentityPoolConfigs() {
            return this.identityPoolConfigs != null ? this.identityPoolConfigs.toBuilder() : null;
        }

        public final void setIdentityPoolConfigs(CreateBackendAuthIdentityPoolConfig.BuilderImpl identityPoolConfigs) {
            this.identityPoolConfigs = identityPoolConfigs != null ? identityPoolConfigs.build() : null;
        }

        @Override
        public final Builder identityPoolConfigs(CreateBackendAuthIdentityPoolConfig identityPoolConfigs) {
            this.identityPoolConfigs = identityPoolConfigs;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(Service service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final CreateBackendAuthUserPoolConfig.Builder getUserPoolConfigs() {
            return this.userPoolConfigs != null ? this.userPoolConfigs.toBuilder() : null;
        }

        public final void setUserPoolConfigs(CreateBackendAuthUserPoolConfig.BuilderImpl userPoolConfigs) {
            this.userPoolConfigs = userPoolConfigs != null ? userPoolConfigs.build() : null;
        }

        @Override
        public final Builder userPoolConfigs(CreateBackendAuthUserPoolConfig userPoolConfigs) {
            this.userPoolConfigs = userPoolConfigs;
            return this;
        }

        public CreateBackendAuthResourceConfig build() {
            return new CreateBackendAuthResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBackendAuthResourceConfig> {
        public Builder authResources(String var1);

        public Builder authResources(AuthResources var1);

        public Builder identityPoolConfigs(CreateBackendAuthIdentityPoolConfig var1);

        default public Builder identityPoolConfigs(Consumer<CreateBackendAuthIdentityPoolConfig.Builder> identityPoolConfigs) {
            return this.identityPoolConfigs((CreateBackendAuthIdentityPoolConfig)((CreateBackendAuthIdentityPoolConfig.Builder)CreateBackendAuthIdentityPoolConfig.builder().applyMutation(identityPoolConfigs)).build());
        }

        public Builder service(String var1);

        public Builder service(Service var1);

        public Builder userPoolConfigs(CreateBackendAuthUserPoolConfig var1);

        default public Builder userPoolConfigs(Consumer<CreateBackendAuthUserPoolConfig.Builder> userPoolConfigs) {
            return this.userPoolConfigs((CreateBackendAuthUserPoolConfig)((CreateBackendAuthUserPoolConfig.Builder)CreateBackendAuthUserPoolConfig.builder().applyMutation(userPoolConfigs)).build());
        }
    }
}

