/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.SubnetIdListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.VpcLinkStatus;
import software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcLinkResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, CreateVpcLinkResponse> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::createdDate)).setter(CreateVpcLinkResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::name)).setter(CreateVpcLinkResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::securityGroupIds)).setter(CreateVpcLinkResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::subnetIds)).setter(CreateVpcLinkResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::tags)).setter(CreateVpcLinkResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkId").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::vpcLinkId)).setter(CreateVpcLinkResponse.setter(Builder::vpcLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkId").build()}).build();
    private static final SdkField<String> VPC_LINK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkStatus").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::vpcLinkStatusAsString)).setter(CreateVpcLinkResponse.setter(Builder::vpcLinkStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatus").build()}).build();
    private static final SdkField<String> VPC_LINK_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkStatusMessage").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::vpcLinkStatusMessage)).setter(CreateVpcLinkResponse.setter(Builder::vpcLinkStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatusMessage").build()}).build();
    private static final SdkField<String> VPC_LINK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkVersion").getter(CreateVpcLinkResponse.getter(CreateVpcLinkResponse::vpcLinkVersionAsString)).setter(CreateVpcLinkResponse.setter(Builder::vpcLinkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD, NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_LINK_ID_FIELD, VPC_LINK_STATUS_FIELD, VPC_LINK_STATUS_MESSAGE_FIELD, VPC_LINK_VERSION_FIELD));
    private final Instant createdDate;
    private final String name;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final String vpcLinkId;
    private final String vpcLinkStatus;
    private final String vpcLinkStatusMessage;
    private final String vpcLinkVersion;

    private CreateVpcLinkResponse(BuilderImpl builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcLinkId = builder.vpcLinkId;
        this.vpcLinkStatus = builder.vpcLinkStatus;
        this.vpcLinkStatusMessage = builder.vpcLinkStatusMessage;
        this.vpcLinkVersion = builder.vpcLinkVersion;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vpcLinkId() {
        return this.vpcLinkId;
    }

    public final VpcLinkStatus vpcLinkStatus() {
        return VpcLinkStatus.fromValue(this.vpcLinkStatus);
    }

    public final String vpcLinkStatusAsString() {
        return this.vpcLinkStatus;
    }

    public final String vpcLinkStatusMessage() {
        return this.vpcLinkStatusMessage;
    }

    public final VpcLinkVersion vpcLinkVersion() {
        return VpcLinkVersion.fromValue(this.vpcLinkVersion);
    }

    public final String vpcLinkVersionAsString() {
        return this.vpcLinkVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcLinkResponse)) {
            return false;
        }
        CreateVpcLinkResponse other = (CreateVpcLinkResponse)((Object)obj);
        return Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.name(), other.name()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcLinkId(), other.vpcLinkId()) && Objects.equals(this.vpcLinkStatusAsString(), other.vpcLinkStatusAsString()) && Objects.equals(this.vpcLinkStatusMessage(), other.vpcLinkStatusMessage()) && Objects.equals(this.vpcLinkVersionAsString(), other.vpcLinkVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcLinkResponse").add("CreatedDate", (Object)this.createdDate()).add("Name", (Object)this.name()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcLinkId", (Object)this.vpcLinkId()).add("VpcLinkStatus", (Object)this.vpcLinkStatusAsString()).add("VpcLinkStatusMessage", (Object)this.vpcLinkStatusMessage()).add("VpcLinkVersion", (Object)this.vpcLinkVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcLinkId": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkId()));
            }
            case "VpcLinkStatus": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkStatusAsString()));
            }
            case "VpcLinkStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkStatusMessage()));
            }
            case "VpcLinkVersion": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcLinkResponse, T> g) {
        return obj -> g.apply((CreateVpcLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private Instant createdDate;
        private String name;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcLinkId;
        private String vpcLinkStatus;
        private String vpcLinkStatusMessage;
        private String vpcLinkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcLinkResponse model) {
            super(model);
            this.createdDate(model.createdDate);
            this.name(model.name);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.vpcLinkId(model.vpcLinkId);
            this.vpcLinkStatus(model.vpcLinkStatus);
            this.vpcLinkStatusMessage(model.vpcLinkStatusMessage);
            this.vpcLinkVersion(model.vpcLinkVersion);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getVpcLinkId() {
            return this.vpcLinkId;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final String getVpcLinkStatus() {
            return this.vpcLinkStatus;
        }

        public final void setVpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
        }

        @Override
        public final Builder vpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
            return this;
        }

        @Override
        public final Builder vpcLinkStatus(VpcLinkStatus vpcLinkStatus) {
            this.vpcLinkStatus(vpcLinkStatus == null ? null : vpcLinkStatus.toString());
            return this;
        }

        public final String getVpcLinkStatusMessage() {
            return this.vpcLinkStatusMessage;
        }

        public final void setVpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
        }

        @Override
        public final Builder vpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
            return this;
        }

        public final String getVpcLinkVersion() {
            return this.vpcLinkVersion;
        }

        public final void setVpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
        }

        @Override
        public final Builder vpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
            return this;
        }

        @Override
        public final Builder vpcLinkVersion(VpcLinkVersion vpcLinkVersion) {
            this.vpcLinkVersion(vpcLinkVersion == null ? null : vpcLinkVersion.toString());
            return this;
        }

        @Override
        public CreateVpcLinkResponse build() {
            return new CreateVpcLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcLinkResponse> {
        public Builder createdDate(Instant var1);

        public Builder name(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcLinkId(String var1);

        public Builder vpcLinkStatus(String var1);

        public Builder vpcLinkStatus(VpcLinkStatus var1);

        public Builder vpcLinkStatusMessage(String var1);

        public Builder vpcLinkVersion(String var1);

        public Builder vpcLinkVersion(VpcLinkVersion var1);
    }
}

