/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.Authorization;
import software.amazon.awssdk.services.apigatewayv2.model.EndpointConfigurationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.PortalContent;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringMin20Max2048Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePortalRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreatePortalRequest> {
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authorization").getter(CreatePortalRequest.getter(CreatePortalRequest::authorization)).setter(CreatePortalRequest.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<EndpointConfigurationRequest> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(CreatePortalRequest.getter(CreatePortalRequest::endpointConfiguration)).setter(CreatePortalRequest.setter(Builder::endpointConfiguration)).constructor(EndpointConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<List<String>> INCLUDED_PORTAL_PRODUCT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedPortalProductArns").getter(CreatePortalRequest.getter(CreatePortalRequest::includedPortalProductArns)).setter(CreatePortalRequest.setter(Builder::includedPortalProductArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedPortalProductArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOGO_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogoUri").getter(CreatePortalRequest.getter(CreatePortalRequest::logoUri)).setter(CreatePortalRequest.setter(Builder::logoUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoUri").build()}).build();
    private static final SdkField<PortalContent> PORTAL_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortalContent").getter(CreatePortalRequest.getter(CreatePortalRequest::portalContent)).setter(CreatePortalRequest.setter(Builder::portalContent)).constructor(PortalContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContent").build()}).build();
    private static final SdkField<String> RUM_APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RumAppMonitorName").getter(CreatePortalRequest.getter(CreatePortalRequest::rumAppMonitorName)).setter(CreatePortalRequest.setter(Builder::rumAppMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rumAppMonitorName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreatePortalRequest.getter(CreatePortalRequest::tags)).setter(CreatePortalRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD, ENDPOINT_CONFIGURATION_FIELD, INCLUDED_PORTAL_PRODUCT_ARNS_FIELD, LOGO_URI_FIELD, PORTAL_CONTENT_FIELD, RUM_APP_MONITOR_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePortalRequest.memberNameToFieldInitializer();
    private final Authorization authorization;
    private final EndpointConfigurationRequest endpointConfiguration;
    private final List<String> includedPortalProductArns;
    private final String logoUri;
    private final PortalContent portalContent;
    private final String rumAppMonitorName;
    private final Map<String, String> tags;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.authorization = builder.authorization;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.includedPortalProductArns = builder.includedPortalProductArns;
        this.logoUri = builder.logoUri;
        this.portalContent = builder.portalContent;
        this.rumAppMonitorName = builder.rumAppMonitorName;
        this.tags = builder.tags;
    }

    public final Authorization authorization() {
        return this.authorization;
    }

    public final EndpointConfigurationRequest endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final boolean hasIncludedPortalProductArns() {
        return this.includedPortalProductArns != null && !(this.includedPortalProductArns instanceof SdkAutoConstructList);
    }

    public final List<String> includedPortalProductArns() {
        return this.includedPortalProductArns;
    }

    public final String logoUri() {
        return this.logoUri;
    }

    public final PortalContent portalContent() {
        return this.portalContent;
    }

    public final String rumAppMonitorName() {
        return this.rumAppMonitorName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedPortalProductArns() ? this.includedPortalProductArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logoUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.rumAppMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest)((Object)obj);
        return Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && this.hasIncludedPortalProductArns() == other.hasIncludedPortalProductArns() && Objects.equals(this.includedPortalProductArns(), other.includedPortalProductArns()) && Objects.equals(this.logoUri(), other.logoUri()) && Objects.equals(this.portalContent(), other.portalContent()) && Objects.equals(this.rumAppMonitorName(), other.rumAppMonitorName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePortalRequest").add("Authorization", (Object)this.authorization()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("IncludedPortalProductArns", this.hasIncludedPortalProductArns() ? this.includedPortalProductArns() : null).add("LogoUri", (Object)this.logoUri()).add("PortalContent", (Object)this.portalContent()).add("RumAppMonitorName", (Object)this.rumAppMonitorName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "IncludedPortalProductArns": {
                return Optional.ofNullable(clazz.cast(this.includedPortalProductArns()));
            }
            case "LogoUri": {
                return Optional.ofNullable(clazz.cast(this.logoUri()));
            }
            case "PortalContent": {
                return Optional.ofNullable(clazz.cast(this.portalContent()));
            }
            case "RumAppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.rumAppMonitorName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorization", AUTHORIZATION_FIELD);
        map.put("endpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("includedPortalProductArns", INCLUDED_PORTAL_PRODUCT_ARNS_FIELD);
        map.put("logoUri", LOGO_URI_FIELD);
        map.put("portalContent", PORTAL_CONTENT_FIELD);
        map.put("rumAppMonitorName", RUM_APP_MONITOR_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private Authorization authorization;
        private EndpointConfigurationRequest endpointConfiguration;
        private List<String> includedPortalProductArns = DefaultSdkAutoConstructList.getInstance();
        private String logoUri;
        private PortalContent portalContent;
        private String rumAppMonitorName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            this.authorization(model.authorization);
            this.endpointConfiguration(model.endpointConfiguration);
            this.includedPortalProductArns(model.includedPortalProductArns);
            this.logoUri(model.logoUri);
            this.portalContent(model.portalContent);
            this.rumAppMonitorName(model.rumAppMonitorName);
            this.tags(model.tags);
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final EndpointConfigurationRequest.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfigurationRequest.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfigurationRequest endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final Collection<String> getIncludedPortalProductArns() {
            if (this.includedPortalProductArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedPortalProductArns;
        }

        public final void setIncludedPortalProductArns(Collection<String> includedPortalProductArns) {
            this.includedPortalProductArns = ___listOf__stringMin20Max2048Copier.copy(includedPortalProductArns);
        }

        @Override
        public final Builder includedPortalProductArns(Collection<String> includedPortalProductArns) {
            this.includedPortalProductArns = ___listOf__stringMin20Max2048Copier.copy(includedPortalProductArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedPortalProductArns(String ... includedPortalProductArns) {
            this.includedPortalProductArns(Arrays.asList(includedPortalProductArns));
            return this;
        }

        public final String getLogoUri() {
            return this.logoUri;
        }

        public final void setLogoUri(String logoUri) {
            this.logoUri = logoUri;
        }

        @Override
        public final Builder logoUri(String logoUri) {
            this.logoUri = logoUri;
            return this;
        }

        public final PortalContent.Builder getPortalContent() {
            return this.portalContent != null ? this.portalContent.toBuilder() : null;
        }

        public final void setPortalContent(PortalContent.BuilderImpl portalContent) {
            this.portalContent = portalContent != null ? portalContent.build() : null;
        }

        @Override
        public final Builder portalContent(PortalContent portalContent) {
            this.portalContent = portalContent;
            return this;
        }

        public final String getRumAppMonitorName() {
            return this.rumAppMonitorName;
        }

        public final void setRumAppMonitorName(String rumAppMonitorName) {
            this.rumAppMonitorName = rumAppMonitorName;
        }

        @Override
        public final Builder rumAppMonitorName(String rumAppMonitorName) {
            this.rumAppMonitorName = rumAppMonitorName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePortalRequest> {
        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder endpointConfiguration(EndpointConfigurationRequest var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfigurationRequest.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfigurationRequest)((EndpointConfigurationRequest.Builder)EndpointConfigurationRequest.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder includedPortalProductArns(Collection<String> var1);

        public Builder includedPortalProductArns(String ... var1);

        public Builder logoUri(String var1);

        public Builder portalContent(PortalContent var1);

        default public Builder portalContent(Consumer<PortalContent.Builder> portalContent) {
            return this.portalContent((PortalContent)((PortalContent.Builder)PortalContent.builder().applyMutation(portalContent)).build());
        }

        public Builder rumAppMonitorName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

