/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfigurationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointConfigurationResponse> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(EndpointConfigurationResponse.getter(EndpointConfigurationResponse::certificateArn)).setter(EndpointConfigurationResponse.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(EndpointConfigurationResponse.getter(EndpointConfigurationResponse::domainName)).setter(EndpointConfigurationResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> PORTAL_DEFAULT_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalDefaultDomainName").getter(EndpointConfigurationResponse.getter(EndpointConfigurationResponse::portalDefaultDomainName)).setter(EndpointConfigurationResponse.setter(Builder::portalDefaultDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDefaultDomainName").build()}).build();
    private static final SdkField<String> PORTAL_DOMAIN_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalDomainHostedZoneId").getter(EndpointConfigurationResponse.getter(EndpointConfigurationResponse::portalDomainHostedZoneId)).setter(EndpointConfigurationResponse.setter(Builder::portalDomainHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDomainHostedZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, DOMAIN_NAME_FIELD, PORTAL_DEFAULT_DOMAIN_NAME_FIELD, PORTAL_DOMAIN_HOSTED_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointConfigurationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String domainName;
    private final String portalDefaultDomainName;
    private final String portalDomainHostedZoneId;

    private EndpointConfigurationResponse(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
        this.portalDefaultDomainName = builder.portalDefaultDomainName;
        this.portalDomainHostedZoneId = builder.portalDomainHostedZoneId;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String portalDefaultDomainName() {
        return this.portalDefaultDomainName;
    }

    public final String portalDomainHostedZoneId() {
        return this.portalDomainHostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalDefaultDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalDomainHostedZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfigurationResponse)) {
            return false;
        }
        EndpointConfigurationResponse other = (EndpointConfigurationResponse)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.portalDefaultDomainName(), other.portalDefaultDomainName()) && Objects.equals(this.portalDomainHostedZoneId(), other.portalDomainHostedZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointConfigurationResponse").add("CertificateArn", (Object)this.certificateArn()).add("DomainName", (Object)this.domainName()).add("PortalDefaultDomainName", (Object)this.portalDefaultDomainName()).add("PortalDomainHostedZoneId", (Object)this.portalDomainHostedZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "PortalDefaultDomainName": {
                return Optional.ofNullable(clazz.cast(this.portalDefaultDomainName()));
            }
            case "PortalDomainHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.portalDomainHostedZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("portalDefaultDomainName", PORTAL_DEFAULT_DOMAIN_NAME_FIELD);
        map.put("portalDomainHostedZoneId", PORTAL_DOMAIN_HOSTED_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfigurationResponse, T> g) {
        return obj -> g.apply((EndpointConfigurationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;
        private String portalDefaultDomainName;
        private String portalDomainHostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfigurationResponse model) {
            this.certificateArn(model.certificateArn);
            this.domainName(model.domainName);
            this.portalDefaultDomainName(model.portalDefaultDomainName);
            this.portalDomainHostedZoneId(model.portalDomainHostedZoneId);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getPortalDefaultDomainName() {
            return this.portalDefaultDomainName;
        }

        public final void setPortalDefaultDomainName(String portalDefaultDomainName) {
            this.portalDefaultDomainName = portalDefaultDomainName;
        }

        @Override
        public final Builder portalDefaultDomainName(String portalDefaultDomainName) {
            this.portalDefaultDomainName = portalDefaultDomainName;
            return this;
        }

        public final String getPortalDomainHostedZoneId() {
            return this.portalDomainHostedZoneId;
        }

        public final void setPortalDomainHostedZoneId(String portalDomainHostedZoneId) {
            this.portalDomainHostedZoneId = portalDomainHostedZoneId;
        }

        @Override
        public final Builder portalDomainHostedZoneId(String portalDomainHostedZoneId) {
            this.portalDomainHostedZoneId = portalDomainHostedZoneId;
            return this;
        }

        public EndpointConfigurationResponse build() {
            return new EndpointConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointConfigurationResponse> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);

        public Builder portalDefaultDomainName(String var1);

        public Builder portalDomainHostedZoneId(String var1);
    }
}

