/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.EndpointDisplayContent;
import software.amazon.awssdk.services.apigatewayv2.model.TryItState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProductRestEndpointPageRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateProductRestEndpointPageRequest> {
    private static final SdkField<EndpointDisplayContent> DISPLAY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayContent").getter(UpdateProductRestEndpointPageRequest.getter(UpdateProductRestEndpointPageRequest::displayContent)).setter(UpdateProductRestEndpointPageRequest.setter(Builder::displayContent)).constructor(EndpointDisplayContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayContent").build()}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(UpdateProductRestEndpointPageRequest.getter(UpdateProductRestEndpointPageRequest::portalProductId)).setter(UpdateProductRestEndpointPageRequest.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalProductId").build()}).build();
    private static final SdkField<String> PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductRestEndpointPageId").getter(UpdateProductRestEndpointPageRequest.getter(UpdateProductRestEndpointPageRequest::productRestEndpointPageId)).setter(UpdateProductRestEndpointPageRequest.setter(Builder::productRestEndpointPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("productRestEndpointPageId").build()}).build();
    private static final SdkField<String> TRY_IT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TryItState").getter(UpdateProductRestEndpointPageRequest.getter(UpdateProductRestEndpointPageRequest::tryItStateAsString)).setter(UpdateProductRestEndpointPageRequest.setter(Builder::tryItState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tryItState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_CONTENT_FIELD, PORTAL_PRODUCT_ID_FIELD, PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD, TRY_IT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProductRestEndpointPageRequest.memberNameToFieldInitializer();
    private final EndpointDisplayContent displayContent;
    private final String portalProductId;
    private final String productRestEndpointPageId;
    private final String tryItState;

    private UpdateProductRestEndpointPageRequest(BuilderImpl builder) {
        super(builder);
        this.displayContent = builder.displayContent;
        this.portalProductId = builder.portalProductId;
        this.productRestEndpointPageId = builder.productRestEndpointPageId;
        this.tryItState = builder.tryItState;
    }

    public final EndpointDisplayContent displayContent() {
        return this.displayContent;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    public final String productRestEndpointPageId() {
        return this.productRestEndpointPageId;
    }

    public final TryItState tryItState() {
        return TryItState.fromValue(this.tryItState);
    }

    public final String tryItStateAsString() {
        return this.tryItState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productRestEndpointPageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tryItStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRestEndpointPageRequest)) {
            return false;
        }
        UpdateProductRestEndpointPageRequest other = (UpdateProductRestEndpointPageRequest)((Object)obj);
        return Objects.equals(this.displayContent(), other.displayContent()) && Objects.equals(this.portalProductId(), other.portalProductId()) && Objects.equals(this.productRestEndpointPageId(), other.productRestEndpointPageId()) && Objects.equals(this.tryItStateAsString(), other.tryItStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProductRestEndpointPageRequest").add("DisplayContent", (Object)this.displayContent()).add("PortalProductId", (Object)this.portalProductId()).add("ProductRestEndpointPageId", (Object)this.productRestEndpointPageId()).add("TryItState", (Object)this.tryItStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayContent": {
                return Optional.ofNullable(clazz.cast(this.displayContent()));
            }
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
            case "ProductRestEndpointPageId": {
                return Optional.ofNullable(clazz.cast(this.productRestEndpointPageId()));
            }
            case "TryItState": {
                return Optional.ofNullable(clazz.cast(this.tryItStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayContent", DISPLAY_CONTENT_FIELD);
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        map.put("productRestEndpointPageId", PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD);
        map.put("tryItState", TRY_IT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductRestEndpointPageRequest, T> g) {
        return obj -> g.apply((UpdateProductRestEndpointPageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private EndpointDisplayContent displayContent;
        private String portalProductId;
        private String productRestEndpointPageId;
        private String tryItState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRestEndpointPageRequest model) {
            super(model);
            this.displayContent(model.displayContent);
            this.portalProductId(model.portalProductId);
            this.productRestEndpointPageId(model.productRestEndpointPageId);
            this.tryItState(model.tryItState);
        }

        public final EndpointDisplayContent.Builder getDisplayContent() {
            return this.displayContent != null ? this.displayContent.toBuilder() : null;
        }

        public final void setDisplayContent(EndpointDisplayContent.BuilderImpl displayContent) {
            this.displayContent = displayContent != null ? displayContent.build() : null;
        }

        @Override
        public final Builder displayContent(EndpointDisplayContent displayContent) {
            this.displayContent = displayContent;
            return this;
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        public final String getProductRestEndpointPageId() {
            return this.productRestEndpointPageId;
        }

        public final void setProductRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
        }

        @Override
        public final Builder productRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
            return this;
        }

        public final String getTryItState() {
            return this.tryItState;
        }

        public final void setTryItState(String tryItState) {
            this.tryItState = tryItState;
        }

        @Override
        public final Builder tryItState(String tryItState) {
            this.tryItState = tryItState;
            return this;
        }

        @Override
        public final Builder tryItState(TryItState tryItState) {
            this.tryItState(tryItState == null ? null : tryItState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRestEndpointPageRequest build() {
            return new UpdateProductRestEndpointPageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProductRestEndpointPageRequest> {
        public Builder displayContent(EndpointDisplayContent var1);

        default public Builder displayContent(Consumer<EndpointDisplayContent.Builder> displayContent) {
            return this.displayContent((EndpointDisplayContent)((EndpointDisplayContent.Builder)EndpointDisplayContent.builder().applyMutation(displayContent)).build());
        }

        public Builder portalProductId(String var1);

        public Builder productRestEndpointPageId(String var1);

        public Builder tryItState(String var1);

        public Builder tryItState(TryItState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

