/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2Client;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListRoutingRulesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListRoutingRulesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRule;

public class ListRoutingRulesIterable
implements SdkIterable<ListRoutingRulesResponse> {
    private final ApiGatewayV2Client client;
    private final ListRoutingRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutingRulesIterable(ApiGatewayV2Client client, ListRoutingRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoutingRulesResponseFetcher();
    }

    public Iterator<ListRoutingRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoutingRule> routingRules() {
        Function<ListRoutingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingRules() != null) {
                return response.routingRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoutingRulesResponseFetcher
    implements SyncPageFetcher<ListRoutingRulesResponse> {
        private ListRoutingRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutingRulesResponse nextPage(ListRoutingRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingRulesIterable.this.client.listRoutingRules(ListRoutingRulesIterable.this.firstRequest);
            }
            return ListRoutingRulesIterable.this.client.listRoutingRules((ListRoutingRulesRequest)((Object)ListRoutingRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

