/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngestionRequest extends AppFabricRequest implements
        ToCopyableBuilder<CreateIngestionRequest.Builder, CreateIngestionRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(CreateIngestionRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("app")
            .getter(getter(CreateIngestionRequest::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantId").getter(getter(CreateIngestionRequest::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()).build();

    private static final SdkField<String> INGESTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionType").getter(getter(CreateIngestionRequest::ingestionTypeAsString))
            .setter(setter(Builder::ingestionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionType").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateIngestionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateIngestionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            APP_FIELD, TENANT_ID_FIELD, INGESTION_TYPE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String appBundleIdentifier;

    private final String app;

    private final String tenantId;

    private final String ingestionType;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateIngestionRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.ingestionType = builder.ingestionType;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SLACK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASANA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JIRA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>M365</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>M365AUDITLOGS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZOOM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZENDESK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OKTA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DROPBOX</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMARTSHEET</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CISCO</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the application.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SLACK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASANA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JIRA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>M365</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>M365AUDITLOGS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZOOM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZENDESK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OKTA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DROPBOX</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMARTSHEET</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CISCO</code>
     *         </p>
     *         </li>
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * The ID of the application tenant.
     * </p>
     * 
     * @return The ID of the application tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The ingestion type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The ingestion type.
     * @see IngestionType
     */
    public final IngestionType ingestionType() {
        return IngestionType.fromValue(ingestionType);
    }

    /**
     * <p>
     * The ingestion type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The ingestion type.
     * @see IngestionType
     */
    public final String ingestionTypeAsString() {
        return ingestionType;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
     * lets you safely retry the request without accidentally performing the same operation a second time. Passing the
     * same value to a later call to an operation requires that you also pass the same value for all other parameters.
     * We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of
     * value</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         This lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionRequest)) {
            return false;
        }
        CreateIngestionRequest other = (CreateIngestionRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(app(), other.app())
                && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(ingestionTypeAsString(), other.ingestionTypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngestionRequest").add("AppBundleIdentifier", appBundleIdentifier()).add("App", app())
                .add("TenantId", tenantId()).add("IngestionType", ingestionTypeAsString()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "tenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "ingestionType":
            return Optional.ofNullable(clazz.cast(ingestionTypeAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestionRequest, T> g) {
        return obj -> g.apply((CreateIngestionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIngestionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The name of the application.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SLACK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASANA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JIRA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>M365</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>M365AUDITLOGS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZOOM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZENDESK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OKTA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DROPBOX</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMARTSHEET</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CISCO</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param app
         *        The name of the application.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SLACK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASANA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JIRA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>M365</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>M365AUDITLOGS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZOOM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZENDESK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OKTA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DROPBOX</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMARTSHEET</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CISCO</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * The ID of the application tenant.
         * </p>
         * 
         * @param tenantId
         *        The ID of the application tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The ingestion type.
         * </p>
         * 
         * @param ingestionType
         *        The ingestion type.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(String ingestionType);

        /**
         * <p>
         * The ingestion type.
         * </p>
         * 
         * @param ingestionType
         *        The ingestion type.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(IngestionType ingestionType);

        /**
         * <p>
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         * lets you safely retry the request without accidentally performing the same operation a second time. Passing
         * the same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        request. This lets you safely retry the request without accidentally performing the same operation a
         *        second time. Passing the same value to a later call to an operation requires that you also pass the
         *        same value for all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.appfabric.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private String app;

        private String tenantId;

        private String ingestionType;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestionRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            app(model.app);
            tenantId(model.tenantId);
            ingestionType(model.ingestionType);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getIngestionType() {
            return ingestionType;
        }

        public final void setIngestionType(String ingestionType) {
            this.ingestionType = ingestionType;
        }

        @Override
        public final Builder ingestionType(String ingestionType) {
            this.ingestionType = ingestionType;
            return this;
        }

        @Override
        public final Builder ingestionType(IngestionType ingestionType) {
            this.ingestionType(ingestionType == null ? null : ingestionType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngestionRequest build() {
            return new CreateIngestionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
