/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricResponse;
import software.amazon.awssdk.services.appfabric.model.UserAccessResultItem;
import software.amazon.awssdk.services.appfabric.model.UserAccessResultsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetUserAccessTasksResponse
extends AppFabricResponse
implements ToCopyableBuilder<Builder, BatchGetUserAccessTasksResponse> {
    private static final SdkField<List<UserAccessResultItem>> USER_ACCESS_RESULTS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAccessResultsList").getter(BatchGetUserAccessTasksResponse.getter(BatchGetUserAccessTasksResponse::userAccessResultsList)).setter(BatchGetUserAccessTasksResponse.setter(Builder::userAccessResultsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessResultsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAccessResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ACCESS_RESULTS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetUserAccessTasksResponse.memberNameToFieldInitializer();
    private final List<UserAccessResultItem> userAccessResultsList;

    private BatchGetUserAccessTasksResponse(BuilderImpl builder) {
        super(builder);
        this.userAccessResultsList = builder.userAccessResultsList;
    }

    public final boolean hasUserAccessResultsList() {
        return this.userAccessResultsList != null && !(this.userAccessResultsList instanceof SdkAutoConstructList);
    }

    public final List<UserAccessResultItem> userAccessResultsList() {
        return this.userAccessResultsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAccessResultsList() ? this.userAccessResultsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetUserAccessTasksResponse)) {
            return false;
        }
        BatchGetUserAccessTasksResponse other = (BatchGetUserAccessTasksResponse)((Object)obj);
        return this.hasUserAccessResultsList() == other.hasUserAccessResultsList() && Objects.equals(this.userAccessResultsList(), other.userAccessResultsList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetUserAccessTasksResponse").add("UserAccessResultsList", this.hasUserAccessResultsList() ? this.userAccessResultsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userAccessResultsList": {
                return Optional.ofNullable(clazz.cast(this.userAccessResultsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<UserAccessResultItem>>> map = new HashMap<String, SdkField<List<UserAccessResultItem>>>();
        map.put("userAccessResultsList", USER_ACCESS_RESULTS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetUserAccessTasksResponse, T> g) {
        return obj -> g.apply((BatchGetUserAccessTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricResponse.BuilderImpl
    implements Builder {
        private List<UserAccessResultItem> userAccessResultsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetUserAccessTasksResponse model) {
            super(model);
            this.userAccessResultsList(model.userAccessResultsList);
        }

        public final List<UserAccessResultItem.Builder> getUserAccessResultsList() {
            List<UserAccessResultItem.Builder> result = UserAccessResultsListCopier.copyToBuilder(this.userAccessResultsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAccessResultsList(Collection<UserAccessResultItem.BuilderImpl> userAccessResultsList) {
            this.userAccessResultsList = UserAccessResultsListCopier.copyFromBuilder(userAccessResultsList);
        }

        @Override
        public final Builder userAccessResultsList(Collection<UserAccessResultItem> userAccessResultsList) {
            this.userAccessResultsList = UserAccessResultsListCopier.copy(userAccessResultsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessResultsList(UserAccessResultItem ... userAccessResultsList) {
            this.userAccessResultsList(Arrays.asList(userAccessResultsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessResultsList(Consumer<UserAccessResultItem.Builder> ... userAccessResultsList) {
            this.userAccessResultsList(Stream.of(userAccessResultsList).map(c -> (UserAccessResultItem)((UserAccessResultItem.Builder)UserAccessResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetUserAccessTasksResponse build() {
            return new BatchGetUserAccessTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetUserAccessTasksResponse> {
        public Builder userAccessResultsList(Collection<UserAccessResultItem> var1);

        public Builder userAccessResultsList(UserAccessResultItem ... var1);

        public Builder userAccessResultsList(Consumer<UserAccessResultItem.Builder> ... var1);
    }
}

