/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.IngestionState;
import software.amazon.awssdk.services.appfabric.model.IngestionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ingestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ingestion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Ingestion.getter(Ingestion::arn)).setter(Ingestion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> APP_BUNDLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleArn").getter(Ingestion.getter(Ingestion::appBundleArn)).setter(Ingestion.setter(Builder::appBundleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleArn").build()}).build();
    private static final SdkField<String> APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("app").getter(Ingestion.getter(Ingestion::app)).setter(Ingestion.setter(Builder::app)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantId").getter(Ingestion.getter(Ingestion::tenantId)).setter(Ingestion.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Ingestion.getter(Ingestion::createdAt)).setter(Ingestion.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Ingestion.getter(Ingestion::updatedAt)).setter(Ingestion.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Ingestion.getter(Ingestion::stateAsString)).setter(Ingestion.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> INGESTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionType").getter(Ingestion.getter(Ingestion::ingestionTypeAsString)).setter(Ingestion.setter(Builder::ingestionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, APP_BUNDLE_ARN_FIELD, APP_FIELD, TENANT_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATE_FIELD, INGESTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ingestion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String appBundleArn;
    private final String app;
    private final String tenantId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String state;
    private final String ingestionType;

    private Ingestion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.appBundleArn = builder.appBundleArn;
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.state = builder.state;
        this.ingestionType = builder.ingestionType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String appBundleArn() {
        return this.appBundleArn;
    }

    public final String app() {
        return this.app;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final IngestionState state() {
        return IngestionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final IngestionType ingestionType() {
        return IngestionType.fromValue(this.ingestionType);
    }

    public final String ingestionTypeAsString() {
        return this.ingestionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.app());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ingestion)) {
            return false;
        }
        Ingestion other = (Ingestion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.appBundleArn(), other.appBundleArn()) && Objects.equals(this.app(), other.app()) && Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.ingestionTypeAsString(), other.ingestionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ingestion").add("Arn", (Object)this.arn()).add("AppBundleArn", (Object)this.appBundleArn()).add("App", (Object)this.app()).add("TenantId", (Object)this.tenantId()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("State", (Object)this.stateAsString()).add("IngestionType", (Object)this.ingestionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "appBundleArn": {
                return Optional.ofNullable(clazz.cast(this.appBundleArn()));
            }
            case "app": {
                return Optional.ofNullable(clazz.cast(this.app()));
            }
            case "tenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ingestionType": {
                return Optional.ofNullable(clazz.cast(this.ingestionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("appBundleArn", APP_BUNDLE_ARN_FIELD);
        map.put("app", APP_FIELD);
        map.put("tenantId", TENANT_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("ingestionType", INGESTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ingestion, T> g) {
        return obj -> g.apply((Ingestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String appBundleArn;
        private String app;
        private String tenantId;
        private Instant createdAt;
        private Instant updatedAt;
        private String state;
        private String ingestionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Ingestion model) {
            this.arn(model.arn);
            this.appBundleArn(model.appBundleArn);
            this.app(model.app);
            this.tenantId(model.tenantId);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.state(model.state);
            this.ingestionType(model.ingestionType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAppBundleArn() {
            return this.appBundleArn;
        }

        public final void setAppBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
        }

        @Override
        public final Builder appBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
            return this;
        }

        public final String getApp() {
            return this.app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IngestionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getIngestionType() {
            return this.ingestionType;
        }

        public final void setIngestionType(String ingestionType) {
            this.ingestionType = ingestionType;
        }

        @Override
        public final Builder ingestionType(String ingestionType) {
            this.ingestionType = ingestionType;
            return this;
        }

        @Override
        public final Builder ingestionType(IngestionType ingestionType) {
            this.ingestionType(ingestionType == null ? null : ingestionType.toString());
            return this;
        }

        public Ingestion build() {
            return new Ingestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ingestion> {
        public Builder arn(String var1);

        public Builder appBundleArn(String var1);

        public Builder app(String var1);

        public Builder tenantId(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder state(String var1);

        public Builder state(IngestionState var1);

        public Builder ingestionType(String var1);

        public Builder ingestionType(IngestionType var1);
    }
}

