/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the connector-specific configuration and credentials for the connector profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorProfileConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorProfileConfig.Builder, ConnectorProfileConfig> {
    private static final SdkField<ConnectorProfileProperties> CONNECTOR_PROFILE_PROPERTIES_FIELD = SdkField
            .<ConnectorProfileProperties> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProfileProperties")
            .getter(getter(ConnectorProfileConfig::connectorProfileProperties))
            .setter(setter(Builder::connectorProfileProperties))
            .constructor(ConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileProperties").build())
            .build();

    private static final SdkField<ConnectorProfileCredentials> CONNECTOR_PROFILE_CREDENTIALS_FIELD = SdkField
            .<ConnectorProfileCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProfileCredentials")
            .getter(getter(ConnectorProfileConfig::connectorProfileCredentials))
            .setter(setter(Builder::connectorProfileCredentials))
            .constructor(ConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileCredentials")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTOR_PROFILE_PROPERTIES_FIELD, CONNECTOR_PROFILE_CREDENTIALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConnectorProfileProperties connectorProfileProperties;

    private final ConnectorProfileCredentials connectorProfileCredentials;

    private ConnectorProfileConfig(BuilderImpl builder) {
        this.connectorProfileProperties = builder.connectorProfileProperties;
        this.connectorProfileCredentials = builder.connectorProfileCredentials;
    }

    /**
     * <p>
     * The connector-specific properties of the profile configuration.
     * </p>
     * 
     * @return The connector-specific properties of the profile configuration.
     */
    public final ConnectorProfileProperties connectorProfileProperties() {
        return connectorProfileProperties;
    }

    /**
     * <p>
     * The connector-specific credentials required by each connector.
     * </p>
     * 
     * @return The connector-specific credentials required by each connector.
     */
    public final ConnectorProfileCredentials connectorProfileCredentials() {
        return connectorProfileCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileProperties());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileCredentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProfileConfig)) {
            return false;
        }
        ConnectorProfileConfig other = (ConnectorProfileConfig) obj;
        return Objects.equals(connectorProfileProperties(), other.connectorProfileProperties())
                && Objects.equals(connectorProfileCredentials(), other.connectorProfileCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorProfileConfig").add("ConnectorProfileProperties", connectorProfileProperties())
                .add("ConnectorProfileCredentials", connectorProfileCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileProperties":
            return Optional.ofNullable(clazz.cast(connectorProfileProperties()));
        case "connectorProfileCredentials":
            return Optional.ofNullable(clazz.cast(connectorProfileCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProfileConfig, T> g) {
        return obj -> g.apply((ConnectorProfileConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorProfileConfig> {
        /**
         * <p>
         * The connector-specific properties of the profile configuration.
         * </p>
         * 
         * @param connectorProfileProperties
         *        The connector-specific properties of the profile configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileProperties(ConnectorProfileProperties connectorProfileProperties);

        /**
         * <p>
         * The connector-specific properties of the profile configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorProfileProperties.Builder}
         * avoiding the need to create one manually via {@link ConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProfileProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #connectorProfileProperties(ConnectorProfileProperties)}.
         * 
         * @param connectorProfileProperties
         *        a consumer that will call methods on {@link ConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileProperties(ConnectorProfileProperties)
         */
        default Builder connectorProfileProperties(Consumer<ConnectorProfileProperties.Builder> connectorProfileProperties) {
            return connectorProfileProperties(ConnectorProfileProperties.builder().applyMutation(connectorProfileProperties)
                    .build());
        }

        /**
         * <p>
         * The connector-specific credentials required by each connector.
         * </p>
         * 
         * @param connectorProfileCredentials
         *        The connector-specific credentials required by each connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileCredentials(ConnectorProfileCredentials connectorProfileCredentials);

        /**
         * <p>
         * The connector-specific credentials required by each connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorProfileCredentials.Builder}
         * avoiding the need to create one manually via {@link ConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorProfileCredentials(ConnectorProfileCredentials)}.
         * 
         * @param connectorProfileCredentials
         *        a consumer that will call methods on {@link ConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileCredentials(ConnectorProfileCredentials)
         */
        default Builder connectorProfileCredentials(Consumer<ConnectorProfileCredentials.Builder> connectorProfileCredentials) {
            return connectorProfileCredentials(ConnectorProfileCredentials.builder().applyMutation(connectorProfileCredentials)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectorProfileProperties connectorProfileProperties;

        private ConnectorProfileCredentials connectorProfileCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProfileConfig model) {
            connectorProfileProperties(model.connectorProfileProperties);
            connectorProfileCredentials(model.connectorProfileCredentials);
        }

        public final ConnectorProfileProperties.Builder getConnectorProfileProperties() {
            return connectorProfileProperties != null ? connectorProfileProperties.toBuilder() : null;
        }

        public final void setConnectorProfileProperties(ConnectorProfileProperties.BuilderImpl connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties != null ? connectorProfileProperties.build() : null;
        }

        @Override
        public final Builder connectorProfileProperties(ConnectorProfileProperties connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties;
            return this;
        }

        public final ConnectorProfileCredentials.Builder getConnectorProfileCredentials() {
            return connectorProfileCredentials != null ? connectorProfileCredentials.toBuilder() : null;
        }

        public final void setConnectorProfileCredentials(ConnectorProfileCredentials.BuilderImpl connectorProfileCredentials) {
            this.connectorProfileCredentials = connectorProfileCredentials != null ? connectorProfileCredentials.build() : null;
        }

        @Override
        public final Builder connectorProfileCredentials(ConnectorProfileCredentials connectorProfileCredentials) {
            this.connectorProfileCredentials = connectorProfileCredentials;
            return this;
        }

        @Override
        public ConnectorProfileConfig build() {
            return new ConnectorProfileConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
