/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The API of the connector application that Amazon AppFlow uses to transfer your data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTransferApi implements SdkPojo, Serializable, ToCopyableBuilder<DataTransferApi.Builder, DataTransferApi> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataTransferApi::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DataTransferApi::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private DataTransferApi(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the connector application API.
     * </p>
     * 
     * @return The name of the connector application API.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * You can specify one of the following types:
     * </p>
     * <dl>
     * <dt>AUTOMATIC</dt>
     * <dd>
     * <p>
     * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon
     * AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
     * </p>
     * </dd>
     * <dt>SYNC</dt>
     * <dd>
     * <p>
     * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
     * </p>
     * </dd>
     * <dt>ASYNC</dt>
     * <dd>
     * <p>
     * An asynchronous API. This type of API optimizes a flow for large datasets.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataTransferApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can specify one of the following types:</p>
     *         <dl>
     *         <dt>AUTOMATIC</dt>
     *         <dd>
     *         <p>
     *         The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run,
     *         Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run
     *         transfers.
     *         </p>
     *         </dd>
     *         <dt>SYNC</dt>
     *         <dd>
     *         <p>
     *         A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
     *         </p>
     *         </dd>
     *         <dt>ASYNC</dt>
     *         <dd>
     *         <p>
     *         An asynchronous API. This type of API optimizes a flow for large datasets.
     *         </p>
     *         </dd>
     * @see DataTransferApiType
     */
    public final DataTransferApiType type() {
        return DataTransferApiType.fromValue(type);
    }

    /**
     * <p>
     * You can specify one of the following types:
     * </p>
     * <dl>
     * <dt>AUTOMATIC</dt>
     * <dd>
     * <p>
     * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon
     * AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
     * </p>
     * </dd>
     * <dt>SYNC</dt>
     * <dd>
     * <p>
     * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
     * </p>
     * </dd>
     * <dt>ASYNC</dt>
     * <dd>
     * <p>
     * An asynchronous API. This type of API optimizes a flow for large datasets.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataTransferApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can specify one of the following types:</p>
     *         <dl>
     *         <dt>AUTOMATIC</dt>
     *         <dd>
     *         <p>
     *         The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run,
     *         Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run
     *         transfers.
     *         </p>
     *         </dd>
     *         <dt>SYNC</dt>
     *         <dd>
     *         <p>
     *         A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
     *         </p>
     *         </dd>
     *         <dt>ASYNC</dt>
     *         <dd>
     *         <p>
     *         An asynchronous API. This type of API optimizes a flow for large datasets.
     *         </p>
     *         </dd>
     * @see DataTransferApiType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransferApi)) {
            return false;
        }
        DataTransferApi other = (DataTransferApi) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTransferApi").add("Name", name()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataTransferApi, T> g) {
        return obj -> g.apply((DataTransferApi) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTransferApi> {
        /**
         * <p>
         * The name of the connector application API.
         * </p>
         * 
         * @param name
         *        The name of the connector application API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * You can specify one of the following types:
         * </p>
         * <dl>
         * <dt>AUTOMATIC</dt>
         * <dd>
         * <p>
         * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run,
         * Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
         * </p>
         * </dd>
         * <dt>SYNC</dt>
         * <dd>
         * <p>
         * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
         * </p>
         * </dd>
         * <dt>ASYNC</dt>
         * <dd>
         * <p>
         * An asynchronous API. This type of API optimizes a flow for large datasets.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        You can specify one of the following types:</p>
         *        <dl>
         *        <dt>AUTOMATIC</dt>
         *        <dd>
         *        <p>
         *        The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow
         *        run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run
         *        transfers.
         *        </p>
         *        </dd>
         *        <dt>SYNC</dt>
         *        <dd>
         *        <p>
         *        A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
         *        </p>
         *        </dd>
         *        <dt>ASYNC</dt>
         *        <dd>
         *        <p>
         *        An asynchronous API. This type of API optimizes a flow for large datasets.
         *        </p>
         *        </dd>
         * @see DataTransferApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTransferApiType
         */
        Builder type(String type);

        /**
         * <p>
         * You can specify one of the following types:
         * </p>
         * <dl>
         * <dt>AUTOMATIC</dt>
         * <dd>
         * <p>
         * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run,
         * Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
         * </p>
         * </dd>
         * <dt>SYNC</dt>
         * <dd>
         * <p>
         * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
         * </p>
         * </dd>
         * <dt>ASYNC</dt>
         * <dd>
         * <p>
         * An asynchronous API. This type of API optimizes a flow for large datasets.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        You can specify one of the following types:</p>
         *        <dl>
         *        <dt>AUTOMATIC</dt>
         *        <dd>
         *        <p>
         *        The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow
         *        run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run
         *        transfers.
         *        </p>
         *        </dd>
         *        <dt>SYNC</dt>
         *        <dd>
         *        <p>
         *        A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
         *        </p>
         *        </dd>
         *        <dt>ASYNC</dt>
         *        <dd>
         *        <p>
         *        An asynchronous API. This type of API optimizes a flow for large datasets.
         *        </p>
         *        </dd>
         * @see DataTransferApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTransferApiType
         */
        Builder type(DataTransferApiType type);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransferApi model) {
            name(model.name);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataTransferApiType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public DataTransferApi build() {
            return new DataTransferApi(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
