/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data Catalog. When
 * Amazon AppFlow catalogs your data, it stores metadata in Data Catalog tables. This metadata represents the data
 * that's transferred by the flow that you configure with these settings.
 * </p>
 * <note>
 * <p>
 * You can configure a flow with these settings only when the flow destination is Amazon S3.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueDataCatalogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueDataCatalogConfig.Builder, GlueDataCatalogConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GlueDataCatalogConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GlueDataCatalogConfig::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tablePrefix").getter(getter(GlueDataCatalogConfig::tablePrefix)).setter(setter(Builder::tablePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tablePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DATABASE_NAME_FIELD, TABLE_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String databaseName;

    private final String tablePrefix;

    private GlueDataCatalogConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.databaseName = builder.databaseName;
        this.tablePrefix = builder.tablePrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to create Data
     * Catalog tables, databases, and partitions.
     * </p>
     * <p>
     * For an example IAM policy that has the required permissions, see <a
     * href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html"
     * >Identity-based policy examples for Amazon AppFlow</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to
     *         create Data Catalog tables, databases, and partitions.</p>
     *         <p>
     *         For an example IAM policy that has the required permissions, see <a
     *         href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html"
     *         >Identity-based policy examples for Amazon AppFlow</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in your Amazon
     * Web Services account. These tables contain metadata for the data that's transferred by the flow that you
     * configure with this parameter.
     * </p>
     * <note>
     * <p>
     * When you configure a new flow with this parameter, you must specify an existing database.
     * </p>
     * </note>
     * 
     * @return The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in your
     *         Amazon Web Services account. These tables contain metadata for the data that's transferred by the flow
     *         that you configure with this parameter.</p> <note>
     *         <p>
     *         When you configure a new flow with this parameter, you must specify an existing database.
     *         </p>
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you configure with this
     * setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
     * </p>
     * 
     * @return A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you configure
     *         with this setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
     */
    public final String tablePrefix() {
        return tablePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tablePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueDataCatalogConfig)) {
            return false;
        }
        GlueDataCatalogConfig other = (GlueDataCatalogConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tablePrefix(), other.tablePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueDataCatalogConfig").add("RoleArn", roleArn()).add("DatabaseName", databaseName())
                .add("TablePrefix", tablePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "tablePrefix":
            return Optional.ofNullable(clazz.cast(tablePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueDataCatalogConfig, T> g) {
        return obj -> g.apply((GlueDataCatalogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueDataCatalogConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to create
         * Data Catalog tables, databases, and partitions.
         * </p>
         * <p>
         * For an example IAM policy that has the required permissions, see <a
         * href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html"
         * >Identity-based policy examples for Amazon AppFlow</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to
         *        create Data Catalog tables, databases, and partitions.</p>
         *        <p>
         *        For an example IAM policy that has the required permissions, see <a href=
         *        "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html"
         *        >Identity-based policy examples for Amazon AppFlow</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in your
         * Amazon Web Services account. These tables contain metadata for the data that's transferred by the flow that
         * you configure with this parameter.
         * </p>
         * <note>
         * <p>
         * When you configure a new flow with this parameter, you must specify an existing database.
         * </p>
         * </note>
         * 
         * @param databaseName
         *        The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in
         *        your Amazon Web Services account. These tables contain metadata for the data that's transferred by the
         *        flow that you configure with this parameter.</p> <note>
         *        <p>
         *        When you configure a new flow with this parameter, you must specify an existing database.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you configure with
         * this setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
         * </p>
         * 
         * @param tablePrefix
         *        A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you
         *        configure with this setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePrefix(String tablePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String databaseName;

        private String tablePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueDataCatalogConfig model) {
            roleArn(model.roleArn);
            databaseName(model.databaseName);
            tablePrefix(model.tablePrefix);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTablePrefix() {
            return tablePrefix;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        @Override
        public GlueDataCatalogConfig build() {
            return new GlueDataCatalogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
