/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth 2.0 properties required for OAuth 2.0 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2Properties implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2Properties.Builder, OAuth2Properties> {
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenUrl").getter(getter(OAuth2Properties::tokenUrl)).setter(setter(Builder::tokenUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()).build();

    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oAuth2GrantType").getter(getter(OAuth2Properties::oAuth2GrantTypeAsString))
            .setter(setter(Builder::oAuth2GrantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2GrantType").build()).build();

    private static final SdkField<Map<String, String>> TOKEN_URL_CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tokenUrlCustomProperties")
            .getter(getter(OAuth2Properties::tokenUrlCustomProperties))
            .setter(setter(Builder::tokenUrlCustomProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrlCustomProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_URL_FIELD,
            O_AUTH2_GRANT_TYPE_FIELD, TOKEN_URL_CUSTOM_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tokenUrl;

    private final String oAuth2GrantType;

    private final Map<String, String> tokenUrlCustomProperties;

    private OAuth2Properties(BuilderImpl builder) {
        this.tokenUrl = builder.tokenUrl;
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.tokenUrlCustomProperties = builder.tokenUrlCustomProperties;
    }

    /**
     * <p>
     * The token URL required for OAuth 2.0 authentication.
     * </p>
     * 
     * @return The token URL required for OAuth 2.0 authentication.
     */
    public final String tokenUrl() {
        return tokenUrl;
    }

    /**
     * <p>
     * The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
     * @see OAuth2GrantType
     */
    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(oAuth2GrantType);
    }

    /**
     * <p>
     * The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
     * @see OAuth2GrantType
     */
    public final String oAuth2GrantTypeAsString() {
        return oAuth2GrantType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenUrlCustomProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTokenUrlCustomProperties() {
        return tokenUrlCustomProperties != null && !(tokenUrlCustomProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Associates your token URL with a map of properties that you define. Use this parameter to provide any additional
     * details that the connector requires to authenticate your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenUrlCustomProperties} method.
     * </p>
     * 
     * @return Associates your token URL with a map of properties that you define. Use this parameter to provide any
     *         additional details that the connector requires to authenticate your request.
     */
    public final Map<String, String> tokenUrlCustomProperties() {
        return tokenUrlCustomProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenUrlCustomProperties() ? tokenUrlCustomProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties) obj;
        return Objects.equals(tokenUrl(), other.tokenUrl())
                && Objects.equals(oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString())
                && hasTokenUrlCustomProperties() == other.hasTokenUrlCustomProperties()
                && Objects.equals(tokenUrlCustomProperties(), other.tokenUrlCustomProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2Properties").add("TokenUrl", tokenUrl()).add("OAuth2GrantType", oAuth2GrantTypeAsString())
                .add("TokenUrlCustomProperties", hasTokenUrlCustomProperties() ? tokenUrlCustomProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenUrl":
            return Optional.ofNullable(clazz.cast(tokenUrl()));
        case "oAuth2GrantType":
            return Optional.ofNullable(clazz.cast(oAuth2GrantTypeAsString()));
        case "tokenUrlCustomProperties":
            return Optional.ofNullable(clazz.cast(tokenUrlCustomProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Properties, T> g) {
        return obj -> g.apply((OAuth2Properties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2Properties> {
        /**
         * <p>
         * The token URL required for OAuth 2.0 authentication.
         * </p>
         * 
         * @param tokenUrl
         *        The token URL required for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrl(String tokenUrl);

        /**
         * <p>
         * The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
         * </p>
         * 
         * @param oAuth2GrantType
         *        The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(String oAuth2GrantType);

        /**
         * <p>
         * The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
         * </p>
         * 
         * @param oAuth2GrantType
         *        The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType);

        /**
         * <p>
         * Associates your token URL with a map of properties that you define. Use this parameter to provide any
         * additional details that the connector requires to authenticate your request.
         * </p>
         * 
         * @param tokenUrlCustomProperties
         *        Associates your token URL with a map of properties that you define. Use this parameter to provide any
         *        additional details that the connector requires to authenticate your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties);
    }

    static final class BuilderImpl implements Builder {
        private String tokenUrl;

        private String oAuth2GrantType;

        private Map<String, String> tokenUrlCustomProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Properties model) {
            tokenUrl(model.tokenUrl);
            oAuth2GrantType(model.oAuth2GrantType);
            tokenUrlCustomProperties(model.tokenUrlCustomProperties);
        }

        public final String getTokenUrl() {
            return tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final String getOAuth2GrantType() {
            return oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final Map<String, String> getTokenUrlCustomProperties() {
            if (tokenUrlCustomProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return tokenUrlCustomProperties;
        }

        public final void setTokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
            this.tokenUrlCustomProperties = TokenUrlCustomPropertiesCopier.copy(tokenUrlCustomProperties);
        }

        @Override
        public final Builder tokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
            this.tokenUrlCustomProperties = TokenUrlCustomPropertiesCopier.copy(tokenUrlCustomProperties);
            return this;
        }

        @Override
        public OAuth2Properties build() {
            return new OAuth2Properties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
